/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.asset.display.page.internal.model.listener;

import com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService;
import com.liferay.layout.page.template.exception.RequiredLayoutPageTemplateEntryException;
import com.liferay.layout.page.template.model.LayoutPageTemplateCollection;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.service.LayoutPageTemplateCollectionLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class LayoutPageTemplateCollectionModelListener
extends BaseModelListener<LayoutPageTemplateCollection> {
    @Reference
    private AssetDisplayPageEntryLocalService _assetDisplayPageEntryLocalService;
    @Reference
    private LayoutPageTemplateCollectionLocalService _layoutPageTemplateCollectionLocalService;
    @Reference
    private LayoutPageTemplateEntryLocalService _layoutPageTemplateEntryLocalService;

    public void onBeforeRemove(LayoutPageTemplateCollection layoutPageTemplateCollection) throws ModelListenerException {
        if (this._hasAssetDisplayPageEntry(layoutPageTemplateCollection.getGroupId(), layoutPageTemplateCollection.getLayoutPageTemplateCollectionId())) {
            throw new ModelListenerException((Throwable)new RequiredLayoutPageTemplateEntryException());
        }
    }

    private boolean _hasAssetDisplayPageEntry(long groupId, long layoutPageTemplateCollectionId) {
        List layoutPageTemplateCollections = this._layoutPageTemplateCollectionLocalService.getLayoutPageTemplateCollections(groupId, layoutPageTemplateCollectionId);
        for (LayoutPageTemplateCollection layoutPageTemplateCollection : layoutPageTemplateCollections) {
            if (!this._hasAssetDisplayPageEntry(groupId, layoutPageTemplateCollection.getLayoutPageTemplateCollectionId())) continue;
            return true;
        }
        List layoutPageTemplateEntries = this._layoutPageTemplateEntryLocalService.getLayoutPageTemplateEntries(groupId, layoutPageTemplateCollectionId);
        for (LayoutPageTemplateEntry layoutPageTemplateEntry : layoutPageTemplateEntries) {
            int assetDisplayPageEntriesCount = this._assetDisplayPageEntryLocalService.getAssetDisplayPageEntriesCountByLayoutPageTemplateEntryId(layoutPageTemplateEntry.getLayoutPageTemplateEntryId());
            if (assetDisplayPageEntriesCount <= 0) continue;
            return true;
        }
        return false;
    }
}

