/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.asset.display.page.service.base;

import com.liferay.asset.display.page.model.AssetDisplayPageEntry;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryService;
import com.liferay.asset.display.page.service.AssetDisplayPageEntryServiceUtil;
import com.liferay.asset.display.page.service.persistence.AssetDisplayPageEntryPersistence;
import com.liferay.portal.kernel.bean.BeanReference;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.service.BaseServiceImpl;
import com.liferay.portal.kernel.service.persistence.UserPersistence;
import com.liferay.portal.spring.extender.service.ServiceReference;

import java.sql.Connection;

import javax.sql.DataSource;

/**
 * Provides the base implementation for the asset display page entry remote service.
 *
 * <p>
 * This implementation exists only as a container for the default service methods generated by ServiceBuilder. All custom service methods should be put in {@link com.liferay.asset.display.page.service.impl.AssetDisplayPageEntryServiceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see com.liferay.asset.display.page.service.impl.AssetDisplayPageEntryServiceImpl
 * @generated
 */
public abstract class AssetDisplayPageEntryServiceBaseImpl
	extends BaseServiceImpl
	implements AssetDisplayPageEntryService, IdentifiableOSGiService {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. Use <code>AssetDisplayPageEntryService</code> via injection or a <code>org.osgi.util.tracker.ServiceTracker</code> or use <code>AssetDisplayPageEntryServiceUtil</code>.
	 */

	/**
	 * Returns the asset display page entry local service.
	 *
	 * @return the asset display page entry local service
	 */
	public
		com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService
			getAssetDisplayPageEntryLocalService() {

		return assetDisplayPageEntryLocalService;
	}

	/**
	 * Sets the asset display page entry local service.
	 *
	 * @param assetDisplayPageEntryLocalService the asset display page entry local service
	 */
	public void setAssetDisplayPageEntryLocalService(
		com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService
			assetDisplayPageEntryLocalService) {

		this.assetDisplayPageEntryLocalService =
			assetDisplayPageEntryLocalService;
	}

	/**
	 * Returns the asset display page entry remote service.
	 *
	 * @return the asset display page entry remote service
	 */
	public AssetDisplayPageEntryService getAssetDisplayPageEntryService() {
		return assetDisplayPageEntryService;
	}

	/**
	 * Sets the asset display page entry remote service.
	 *
	 * @param assetDisplayPageEntryService the asset display page entry remote service
	 */
	public void setAssetDisplayPageEntryService(
		AssetDisplayPageEntryService assetDisplayPageEntryService) {

		this.assetDisplayPageEntryService = assetDisplayPageEntryService;
	}

	/**
	 * Returns the asset display page entry persistence.
	 *
	 * @return the asset display page entry persistence
	 */
	public AssetDisplayPageEntryPersistence
		getAssetDisplayPageEntryPersistence() {

		return assetDisplayPageEntryPersistence;
	}

	/**
	 * Sets the asset display page entry persistence.
	 *
	 * @param assetDisplayPageEntryPersistence the asset display page entry persistence
	 */
	public void setAssetDisplayPageEntryPersistence(
		AssetDisplayPageEntryPersistence assetDisplayPageEntryPersistence) {

		this.assetDisplayPageEntryPersistence =
			assetDisplayPageEntryPersistence;
	}

	/**
	 * Returns the counter local service.
	 *
	 * @return the counter local service
	 */
	public com.liferay.counter.kernel.service.CounterLocalService
		getCounterLocalService() {

		return counterLocalService;
	}

	/**
	 * Sets the counter local service.
	 *
	 * @param counterLocalService the counter local service
	 */
	public void setCounterLocalService(
		com.liferay.counter.kernel.service.CounterLocalService
			counterLocalService) {

		this.counterLocalService = counterLocalService;
	}

	/**
	 * Returns the user local service.
	 *
	 * @return the user local service
	 */
	public com.liferay.portal.kernel.service.UserLocalService
		getUserLocalService() {

		return userLocalService;
	}

	/**
	 * Sets the user local service.
	 *
	 * @param userLocalService the user local service
	 */
	public void setUserLocalService(
		com.liferay.portal.kernel.service.UserLocalService userLocalService) {

		this.userLocalService = userLocalService;
	}

	/**
	 * Returns the user remote service.
	 *
	 * @return the user remote service
	 */
	public com.liferay.portal.kernel.service.UserService getUserService() {
		return userService;
	}

	/**
	 * Sets the user remote service.
	 *
	 * @param userService the user remote service
	 */
	public void setUserService(
		com.liferay.portal.kernel.service.UserService userService) {

		this.userService = userService;
	}

	/**
	 * Returns the user persistence.
	 *
	 * @return the user persistence
	 */
	public UserPersistence getUserPersistence() {
		return userPersistence;
	}

	/**
	 * Sets the user persistence.
	 *
	 * @param userPersistence the user persistence
	 */
	public void setUserPersistence(UserPersistence userPersistence) {
		this.userPersistence = userPersistence;
	}

	public void afterPropertiesSet() {
		AssetDisplayPageEntryServiceUtil.setService(
			assetDisplayPageEntryService);
	}

	public void destroy() {
		AssetDisplayPageEntryServiceUtil.setService(null);
	}

	/**
	 * Returns the OSGi service identifier.
	 *
	 * @return the OSGi service identifier
	 */
	@Override
	public String getOSGiServiceIdentifier() {
		return AssetDisplayPageEntryService.class.getName();
	}

	protected Class<?> getModelClass() {
		return AssetDisplayPageEntry.class;
	}

	protected String getModelClassName() {
		return AssetDisplayPageEntry.class.getName();
	}

	/**
	 * Performs a SQL query.
	 *
	 * @param sql the sql query
	 */
	protected void runSQL(String sql) {
		DataSource dataSource =
			assetDisplayPageEntryPersistence.getDataSource();

		DB db = DBManagerUtil.getDB();

		Connection currentConnection = CurrentConnectionUtil.getConnection(
			dataSource);

		try {
			if (currentConnection != null) {
				db.runSQL(currentConnection, new String[] {sql});

				return;
			}

			try (Connection connection = dataSource.getConnection()) {
				db.runSQL(connection, new String[] {sql});
			}
		}
		catch (Exception exception) {
			throw new SystemException(exception);
		}
	}

	@BeanReference(
		type = com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService.class
	)
	protected
		com.liferay.asset.display.page.service.AssetDisplayPageEntryLocalService
			assetDisplayPageEntryLocalService;

	@BeanReference(type = AssetDisplayPageEntryService.class)
	protected AssetDisplayPageEntryService assetDisplayPageEntryService;

	@BeanReference(type = AssetDisplayPageEntryPersistence.class)
	protected AssetDisplayPageEntryPersistence assetDisplayPageEntryPersistence;

	@ServiceReference(
		type = com.liferay.counter.kernel.service.CounterLocalService.class
	)
	protected com.liferay.counter.kernel.service.CounterLocalService
		counterLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.UserLocalService.class
	)
	protected com.liferay.portal.kernel.service.UserLocalService
		userLocalService;

	@ServiceReference(
		type = com.liferay.portal.kernel.service.UserService.class
	)
	protected com.liferay.portal.kernel.service.UserService userService;

	@ServiceReference(type = UserPersistence.class)
	protected UserPersistence userPersistence;

	private static final Log _log = LogFactoryUtil.getLog(
		AssetDisplayPageEntryServiceBaseImpl.class);

}