/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.internal.upgrade.v2_2_0;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeSchema
extends UpgradeProcess {
    private final CounterLocalService _counterLocalService;

    public UpgradeSchema(CounterLocalService counterLocalService) {
        this._counterLocalService = counterLocalService;
    }

    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            String template = StringUtil.read((InputStream)UpgradeSchema.class.getResourceAsStream("dependencies/update.sql"));
            this.runSQLTemplateString(template, false);
            StringBundler sb = new StringBundler(5);
            sb.append("insert into AppBuilderAppVersion (uuid_, ");
            sb.append("appBuilderAppVersionId, groupId, companyId, userId, ");
            sb.append("userName, createDate, modifiedDate, appBuilderAppId, ");
            sb.append("ddlRecordSetId, ddmStructureId, ddmStructureLayoutId, ");
            sb.append("version) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            try (PreparedStatement ps1 = this.connection.prepareStatement("select AppBuilderApp.* from AppBuilderApp");
                 ResultSet rs = ps1.executeQuery();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());){
                while (rs.next()) {
                    ps2.setString(1, PortalUUIDUtil.generate());
                    ps2.setLong(2, this._counterLocalService.increment());
                    ps2.setLong(3, rs.getLong("groupId"));
                    ps2.setLong(4, rs.getLong("companyId"));
                    ps2.setLong(5, rs.getLong("userId"));
                    ps2.setString(6, rs.getString("userName"));
                    ps2.setTimestamp(7, rs.getTimestamp("createDate"));
                    ps2.setTimestamp(8, rs.getTimestamp("modifiedDate"));
                    ps2.setLong(9, rs.getLong("appBuilderAppId"));
                    ps2.setLong(10, rs.getLong("ddlRecordSetId"));
                    ps2.setLong(11, rs.getLong("ddmStructureId"));
                    ps2.setLong(12, rs.getLong("ddmStructureLayoutId"));
                    ps2.setString(13, "1.0");
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }
}

