/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.internal.model.listener;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.model.AppBuilderAppDataRecordLink;
import com.liferay.app.builder.service.AppBuilderAppDataRecordLinkLocalService;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DDLRecordModelListener
extends BaseModelListener<DDLRecord> {
    private static final Log _log = LogFactoryUtil.getLog(DDLRecordModelListener.class);
    @Reference
    private AppBuilderAppDataRecordLinkLocalService _appBuilderAppDataRecordLinkLocalService;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;

    public void onBeforeRemove(DDLRecord ddlRecord) throws ModelListenerException {
        try {
            AppBuilderAppDataRecordLink appBuilderAppDataRecordLink = this._appBuilderAppDataRecordLinkLocalService.fetchDDLRecordAppBuilderAppDataRecordLink(ddlRecord.getRecordId());
            if (Objects.isNull(appBuilderAppDataRecordLink)) {
                return;
            }
            this._appBuilderAppDataRecordLinkLocalService.deleteAppBuilderAppDataRecordLink(appBuilderAppDataRecordLink.getAppBuilderAppDataRecordLinkId());
            this._workflowInstanceLinkLocalService.deleteWorkflowInstanceLinks(appBuilderAppDataRecordLink.getCompanyId(), appBuilderAppDataRecordLink.getGroupId(), ResourceActionsUtil.getCompositeModelName((String[])new String[]{AppBuilderApp.class.getName(), DDLRecord.class.getName()}), ddlRecord.getRecordId());
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
    }
}

