/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.internal.resource.v1_0;

import com.liferay.analytics.cms.rest.dto.v1_0.ExpiredAsset;
import com.liferay.analytics.cms.rest.internal.depot.entry.util.DepotEntryUtil;
import com.liferay.analytics.cms.rest.internal.resource.v1_0.BaseExpiredAssetResourceImpl;
import com.liferay.analytics.cms.rest.internal.resource.v1_0.util.ObjectEntryVersionTitleExpressionUtil;
import com.liferay.analytics.cms.rest.resource.v1_0.ExpiredAssetResource;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.object.entry.util.ObjectEntryThreadLocal;
import com.liferay.object.model.ObjectDefinitionTable;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.ObjectEntryVersionTable;
import com.liferay.object.model.ObjectFolderTable;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.related.models.ObjectRelatedModelsProviderRegistry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.petra.sql.dsl.DSLFunctionFactoryUtil;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.GroupByStep;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@Component(properties={"OSGI-INF/liferay/rest/v1_0/expired-asset.properties"}, scope=ServiceScope.PROTOTYPE, service={ExpiredAssetResource.class})
public class ExpiredAssetResourceImpl
extends BaseExpiredAssetResourceImpl {
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    private final ObjectDefinitionTable _objectDefinitionTable = ObjectDefinitionTable.INSTANCE;
    @Reference
    private ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectEntryTable _objectEntryTable = ObjectEntryTable.INSTANCE;
    private final ObjectEntryVersionTable _objectEntryVersionTable = ObjectEntryVersionTable.INSTANCE;
    private final ObjectFolderTable _objectFolderTable = ObjectFolderTable.INSTANCE;
    @Reference
    private ObjectRelatedModelsProviderRegistry _objectRelatedModelsProviderRegistry;
    @Reference
    private ObjectRelationshipLocalService _objectRelationshipLocalService;
    @Reference
    private Portal _portal;

    @Override
    public Page<ExpiredAsset> getExpiredAssetsPage(Long depotEntryId, String languageId, Pagination pagination) throws Exception {
        Long[] groupIds = DepotEntryUtil.getGroupIds(DepotEntryUtil.getDepotEntries(this.contextCompany.getCompanyId(), depotEntryId));
        Locale locale = LocaleUtil.fromLanguageId((String)languageId, (boolean)true, (boolean)false);
        if (locale == null) {
            locale = this.contextUser.getLocale();
        }
        return Page.of(this.transform(this._getExpiredObjectsList(languageId, groupIds, LanguageUtil.getLanguageId((Locale)locale), pagination), objects -> {
            ExpiredAsset expiredAsset = new ExpiredAsset();
            long objectEntryId = (Long)objects[3];
            expiredAsset.setHref(() -> StringBundler.concat((Object[])new Object[]{this._portal.getPortalURL(this.contextHttpServletRequest), this._portal.getPathMain(), "/cms", "/edit_content_item?&p_l_mode=read&p_p_state=", LiferayWindowState.POP_UP, "&objectEntryId=", objectEntryId}));
            expiredAsset.setTitle(() -> {
                String localizedTitle = String.valueOf(objects[1]);
                if (Validator.isNotNull((String)localizedTitle)) {
                    return localizedTitle;
                }
                return String.valueOf(objects[4]);
            });
            expiredAsset.setUsages(() -> this._getUsagesCount(String.valueOf(objects[0]), (Long)objects[2], objectEntryId));
            return expiredAsset;
        }), (Pagination)pagination, (long)this._getExpiredObjectsListTotalCount(languageId, groupIds));
    }

    private List<Object[]> _getExpiredObjectsList(String filterLanguageId, Long[] groupIds, String languageId, Pagination pagination) {
        DSLQuery dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{this._objectDefinitionTable.className, DSLFunctionFactoryUtil.castClobText(ObjectEntryVersionTitleExpressionUtil.getLocalizedTitleExpression(languageId)).as("localized_title"), this._objectEntryTable.objectDefinitionId, this._objectEntryTable.objectEntryId, DSLFunctionFactoryUtil.castClobText(ObjectEntryVersionTitleExpressionUtil.getTitleExpression()).as("title")}).from((Table)ObjectEntryTable.INSTANCE).innerJoinON((Table)this._objectDefinitionTable, this._objectDefinitionTable.objectDefinitionId.eq((Expression)this._objectEntryTable.objectDefinitionId)).innerJoinON((Table)this._objectFolderTable, this._objectDefinitionTable.objectFolderId.eq((Expression)this._objectFolderTable.objectFolderId)).innerJoinON((Table)this._objectEntryVersionTable, this._objectEntryVersionTable.objectEntryId.eq((Expression)this._objectEntryTable.objectEntryId).and((Expression)this._objectEntryVersionTable.version.eq((Expression)this._objectEntryTable.version))).where(this._getPredicate(groupIds, filterLanguageId)).orderBy(new OrderByExpression[]{this._objectEntryVersionTable.statusDate.descending()}).limit(pagination.getStartPosition(), pagination.getEndPosition());
        return (List)this._objectEntryLocalService.dslQuery(dslQuery);
    }

    private long _getExpiredObjectsListTotalCount(String filterLanguageId, Long[] groupIds) {
        GroupByStep dslQuery = DSLQueryFactoryUtil.select((Expression[])new Expression[]{DSLFunctionFactoryUtil.count((Expression)this._objectEntryTable.objectEntryId).as("totalCount")}).from((Table)ObjectEntryTable.INSTANCE).innerJoinON((Table)this._objectDefinitionTable, this._objectDefinitionTable.objectDefinitionId.eq((Expression)this._objectEntryTable.objectDefinitionId)).innerJoinON((Table)this._objectFolderTable, this._objectDefinitionTable.objectFolderId.eq((Expression)this._objectFolderTable.objectFolderId)).innerJoinON((Table)this._objectEntryVersionTable, this._objectEntryVersionTable.objectEntryId.eq((Expression)this._objectEntryTable.objectEntryId).and((Expression)this._objectEntryVersionTable.version.eq((Expression)this._objectEntryTable.version))).where(this._getPredicate(groupIds, filterLanguageId));
        List results = (List)this._objectEntryLocalService.dslQuery((DSLQuery)dslQuery);
        return GetterUtil.getLong(results.get(0));
    }

    private Predicate _getPredicate(Long[] groupIds, String languageId) {
        Predicate predicate = this._objectEntryTable.groupId.in((Object[])groupIds).and((Expression)this._objectEntryTable.status.eq((Object)3)).and((Expression)this._objectFolderTable.externalReferenceCode.in((Object[])new String[]{"L_CMS_CONTENT_STRUCTURES", "L_CMS_FILE_TYPES"}));
        if (Validator.isNotNull((String)languageId)) {
            predicate = predicate.and((Expression)DSLFunctionFactoryUtil.castClobText(ObjectEntryVersionTitleExpressionUtil.getLocalizedTitleExpression(languageId)).isNotNull());
        }
        return predicate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long _getUsagesCount(String className, long objectDefinitionId, long objectEntryId) throws Exception {
        int usagesCount = this._layoutClassedModelUsageLocalService.getLayoutClassedModelUsagesCount(this._portal.getClassNameId(className), objectEntryId);
        boolean skipObjectEntryResourcePermission = ObjectEntryThreadLocal.isSkipObjectEntryResourcePermission();
        try {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)true);
            List objectRelationships = this._objectRelationshipLocalService.getObjectRelationships(objectDefinitionId);
            for (ObjectRelationship objectRelationship : objectRelationships) {
                ObjectRelatedModelsProvider objectRelatedModelsProvider = this._objectRelatedModelsProviderRegistry.getObjectRelatedModelsProvider(className, this.contextCompany.getCompanyId(), objectRelationship.getType());
                usagesCount += objectRelatedModelsProvider.getRelatedModelsCount(0L, objectRelationship.getObjectRelationshipId(), null, objectEntryId, null);
            }
        }
        finally {
            ObjectEntryThreadLocal.setSkipObjectEntryResourcePermission((boolean)skipObjectEntryResourcePermission);
        }
        return usagesCount;
    }
}

