/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.client.dto.v1_0;

import com.liferay.analytics.cms.rest.client.function.UnsafeSupplier;
import com.liferay.analytics.cms.rest.client.serdes.v1_0.TrendSerDes;
import java.io.Serializable;
import java.util.Objects;

public class Trend
implements Cloneable,
Serializable {
    protected Classification classification;
    protected Double percentage;

    public static Trend toDTO(String json) {
        return TrendSerDes.toDTO(json);
    }

    public Classification getClassification() {
        return this.classification;
    }

    public String getClassificationAsString() {
        if (this.classification == null) {
            return null;
        }
        return this.classification.toString();
    }

    public void setClassification(Classification classification) {
        this.classification = classification;
    }

    public void setClassification(UnsafeSupplier<Classification, Exception> classificationUnsafeSupplier) {
        try {
            this.classification = classificationUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(Double percentage) {
        this.percentage = percentage;
    }

    public void setPercentage(UnsafeSupplier<Double, Exception> percentageUnsafeSupplier) {
        try {
            this.percentage = percentageUnsafeSupplier.get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Trend clone() throws CloneNotSupportedException {
        return (Trend)super.clone();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Trend)) {
            return false;
        }
        Trend trend = (Trend)object;
        return Objects.equals(this.toString(), trend.toString());
    }

    public int hashCode() {
        String string = this.toString();
        return string.hashCode();
    }

    public String toString() {
        return TrendSerDes.toJSON(this);
    }

    public static enum Classification {
        NEGATIVE("NEGATIVE"),
        NEUTRAL("NEUTRAL"),
        POSITIVE("POSITIVE");

        private final String _value;

        public static Classification create(String value) {
            for (Classification classification : Classification.values()) {
                if (!Objects.equals(classification.getValue(), value) && !Objects.equals(classification.name(), value)) continue;
                return classification;
            }
            return null;
        }

        public String getValue() {
            return this._value;
        }

        public String toString() {
            return this._value;
        }

        private Classification(String value) {
            this._value = value;
        }
    }
}

