/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableLong;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableLong
extends ObservableLong {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Long>> observable;

    public RxObservableLong(Observable<Optional<Long>> observable) {
        this.observable = observable;
    }

    public RxObservableLong(long value, Observable<Optional<Long>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableLong(BehaviorSubject<Optional<Long>> subject) {
        super(RxObservableLong.safe((Optional<Long>)((Optional)subject.getValue())));
        this.observable = subject;
    }

    private static long safe(Optional<Long> value) {
        return Utils.safe(value == null ? null : (Long)value.orElse(null));
    }

    @Deprecated
    public void set(long value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableLong.safe((Optional<Long>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

