package xyz.truenight.databinding.rxjava

import androidx.databinding.ObservableInt
import io.reactivex.Flowable
import io.reactivex.Observable
import io.reactivex.disposables.Disposable
import xyz.truenight.utils.optional.Optional
import xyz.truenight.utils.optional.safe
import java.util.concurrent.CopyOnWriteArraySet

/**
 * Copyright (C) 2017 Mikhail Frolov
 */

class RxObservableInt private constructor(val observable: Observable<Int>, default: Int) : ObservableInt(default) {

    private val count = CopyOnWriteArraySet<androidx.databinding.Observable.OnPropertyChangedCallback>()

    private var subscription: Disposable? = null

    override fun addOnPropertyChangedCallback(callback: androidx.databinding.Observable.OnPropertyChangedCallback) {
        super.addOnPropertyChangedCallback(callback)
        if (count.isEmpty()) {
            subscription = observable.subscribe { super.set(it) }
        }
        count.add(callback)
    }

    override fun removeOnPropertyChangedCallback(callback: androidx.databinding.Observable.OnPropertyChangedCallback) {
        super.removeOnPropertyChangedCallback(callback)
        count.remove(callback)
        if (count.isEmpty()) {
            subscription?.dispose()
        }
    }

    companion object {
        private fun safe(value: Optional<Int>?) = value?.value.safe()

        @JvmStatic
        @JvmOverloads
        fun Observable<Int>.toBinding(default: Int = 0) = RxObservableInt(this, default)

        @JvmStatic
        @JvmOverloads
        fun Observable<Optional<Int>>.toBindingOptional(default: Int = 0) = RxObservableInt(this.map { safe(it) }, default)

        @JvmStatic
        @JvmOverloads
        fun Flowable<Int>.toBinding(default: Int = 0) = RxObservableInt(this.toObservable(), default)

        @JvmStatic
        @JvmOverloads
        fun Flowable<Optional<Int>>.toBindingOptional(default: Int = 0) = RxObservableInt(this.map { safe(it) }.toObservable(), default)
    }
}
