/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import androidx.databinding.Observable;
import androidx.databinding.ObservableBoolean;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableBoolean
extends ObservableBoolean {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Boolean>> observable;

    public RxObservableBoolean(Observable<Optional<Boolean>> observable) {
        this.observable = observable;
    }

    public RxObservableBoolean(boolean value, Observable<Optional<Boolean>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableBoolean(BehaviorSubject<Optional<Boolean>> subject) {
        super(RxObservableBoolean.safe((Optional<Boolean>)((Optional)subject.getValue())).booleanValue());
        this.observable = subject;
    }

    private static Boolean safe(Optional<Boolean> value) {
        return Utils.safe(value == null ? null : (Boolean)value.orElse(null));
    }

    @Deprecated
    public void set(boolean value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableBoolean.safe((Optional<Boolean>)value).booleanValue()));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.size() == 0 && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

