/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import io.reactivex.Observable;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import xyz.truenight.utils.Utils;

public class RxRefresh
implements Action {
    private final Subject<Boolean> refresh = PublishSubject.create().toSerialized();
    private Consumer<Throwable> handler;

    private RxRefresh() {
    }

    public static RxRefresh create() {
        return new RxRefresh();
    }

    public static <T> ObservableTransformer<T, T> merge(RxRefresh refresh, RxRefresh ... toMerge) {
        ArrayList<Subject<Boolean>> merged = new ArrayList<Subject<Boolean>>();
        merged.add(refresh.refresh);
        if (Utils.isNotEmpty((Object[])toMerge)) {
            for (RxRefresh rxRefresh : toMerge) {
                merged.add(rxRefresh.refresh);
            }
        }
        Observable merge = Observable.merge(merged);
        return observable -> {
            if (refresh.handler != null) {
                observable = observable.doOnError(refresh.handler);
            }
            return observable.retryWhen(o -> o.flatMap(t -> merge.firstElement().toObservable())).repeatWhen(o -> o.flatMap(t -> merge.firstElement().toObservable()));
        };
    }

    public RxRefresh errorHandler(Consumer<Throwable> handler) {
        this.handler = handler;
        return this;
    }

    public <T> ObservableTransformer<T, T> transformer() {
        return observable -> {
            if (this.handler != null) {
                observable = observable.doOnError(this.handler);
            }
            return observable.retryWhen(o -> o.flatMap(t -> this.refresh.firstElement().toObservable())).repeatWhen(o -> o.flatMap(t -> this.refresh.firstElement().toObservable()));
        };
    }

    public <T> ObservableTransformer<T, T> mergedTransformer(RxRefresh ... toMerge) {
        return RxRefresh.merge(this, toMerge);
    }

    public <T> ObservableTransformer<T, T> transformerWithCondition(Predicate<Boolean> predicate) {
        return observable -> {
            if (this.handler != null) {
                observable = observable.doOnError(this.handler);
            }
            return observable.retryWhen(o -> o.flatMap(t -> this.refresh.takeWhile(predicate).firstElement().toObservable())).repeatWhen(o -> o.flatMap(t -> this.refresh.takeWhile(predicate).firstElement().toObservable()));
        };
    }

    public void run() {
        this.refresh.onNext((Object)false);
    }

    public Action withDelay(long delay, TimeUnit timeUnit) {
        return () -> Observable.timer((long)delay, (TimeUnit)timeUnit).doFinally((Action)this).subscribe();
    }
}

