/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import android.databinding.Observable;
import android.databinding.ObservableChar;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.subjects.BehaviorSubject;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.utils.Optional;
import xyz.truenight.utils.Utils;

public class RxObservableCharacter
extends ObservableChar {
    private Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private Disposable subscription;
    private Observable<Optional<Character>> observable;

    public RxObservableCharacter(Observable<Optional<Character>> observable) {
        this.observable = observable;
    }

    public RxObservableCharacter(char value, Observable<Optional<Character>> observable) {
        super(value);
        this.observable = observable;
    }

    public RxObservableCharacter(BehaviorSubject<Optional<Character>> subject) {
        super(RxObservableCharacter.safe((Optional<Character>)((Optional)subject.getValue())));
        this.observable = subject;
    }

    private static char safe(Optional<Character> value) {
        return ((Character)Utils.safe((Object)(value == null ? null : (Character)value.orElse(null)), (Object)Character.valueOf('\u0000'))).charValue();
    }

    @Deprecated
    public void set(char value) {
        super.set(value);
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (this.count.isEmpty()) {
            this.subscription = this.observable.subscribe(value -> super.set(RxObservableCharacter.safe((Optional<Character>)value)));
        }
        this.count.add(callback);
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty() && this.subscription != null && !this.subscription.isDisposed()) {
            this.subscription.dispose();
        }
    }
}

