/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.rxjava;

import android.databinding.ObservableBoolean;
import io.reactivex.ObservableTransformer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class RxLoading
extends ObservableBoolean {
    private AtomicInteger mCount = new AtomicInteger();

    public static RxLoading create() {
        return new RxLoading();
    }

    private RxLoading() {
    }

    private void inc(Object disposable) {
        if (this.mCount.incrementAndGet() == 1) {
            super.set(true);
        }
    }

    public void inc() {
        if (this.mCount.incrementAndGet() == 1) {
            super.set(true);
        }
    }

    public void dec() {
        if (this.mCount.decrementAndGet() == 0) {
            super.set(false);
        }
    }

    @Deprecated
    public void set(boolean value) {
    }

    public <T> ObservableTransformer<T, T> transformer() {
        return upstream -> upstream.doOnSubscribe(this::inc).doFinally(this::dec);
    }

    public <T> ObservableTransformer<T, T> transformerOnNext() {
        return upstream -> {
            AtomicBoolean loading = new AtomicBoolean();
            return upstream.doOnSubscribe(disposable -> this.loadingStarted(loading)).doOnNext(t -> this.loadingFinished(loading)).doOnError(throwable -> this.loadingFinished(loading)).doOnDispose(() -> this.loadingFinished(loading));
        };
    }

    private void loadingStarted(AtomicBoolean loading) {
        if (!loading.get()) {
            loading.set(true);
            this.inc();
        }
    }

    private void loadingFinished(AtomicBoolean loading) {
        if (loading.get()) {
            loading.set(false);
            this.dec();
        }
    }
}

