/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.realm;

import android.databinding.Observable;
import android.databinding.ObservableField;
import io.realm.Realm;
import io.realm.RealmChangeListener;
import io.realm.RealmConfiguration;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import xyz.truenight.databinding.realm.OnApplyQuery;
import xyz.truenight.databinding.realm.Utils;

public class RealmObservableField<T extends RealmModel>
extends ObservableField<T> {
    private final Set<Observable.OnPropertyChangedCallback> count = new CopyOnWriteArraySet<Observable.OnPropertyChangedCallback>();
    private static final Set<String> EXCLUDE = new HashSet<String>();
    private static OnApplyQuery ALL = new OnApplyQuery(){

        public RealmQuery onApply(RealmQuery query) {
            return query;
        }
    };
    private final RealmConfiguration realmConfig;
    private final Class<T> cls;
    private final OnApplyQuery<T> applyQuery;
    private Realm closable;
    private RealmResults<T> all;
    private final RealmChangeListener<RealmResults<T>> listener;

    public static <E extends RealmModel> OnApplyQuery<E> all() {
        return ALL;
    }

    public RealmObservableField(Class<T> cls, OnApplyQuery<T> apply) {
        this(Realm.getDefaultConfiguration(), cls, apply);
    }

    public RealmObservableField(RealmConfiguration realmConfig, Class<T> cls, OnApplyQuery<T> apply) {
        this.realmConfig = realmConfig;
        this.cls = cls;
        this.applyQuery = apply;
        this.listener = this.createListener();
    }

    @Deprecated
    public void set(T value) {
        super.set(value);
    }

    private RealmChangeListener<RealmResults<T>> createListener() {
        return new RealmChangeListener<RealmResults<T>>(){

            public void onChange(RealmResults<T> t) {
                if (t.isValid()) {
                    RealmObservableField.super.set(Utils.unmanage(RealmObservableField.this.realmConfig, Utils.first(t)));
                }
            }
        };
    }

    public void excludeCallback(Class<? extends Observable.OnPropertyChangedCallback> cls) {
        EXCLUDE.add(cls.getName());
    }

    public void removeExclusion(Class<? extends Observable.OnPropertyChangedCallback> cls) {
        EXCLUDE.remove(cls.getName());
    }

    public void addOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.addOnPropertyChangedCallback(callback);
        if (!EXCLUDE.contains(callback.getClass().getName())) {
            if (this.count.isEmpty()) {
                this.closable = Realm.getInstance((RealmConfiguration)this.realmConfig);
                RealmQuery<T> realmQuery = this.applyQuery.onApply(this.closable.where(this.cls));
                this.all = realmQuery.findAll();
                super.set(Utils.unmanage(this.realmConfig, Utils.first(this.all)));
                this.all.addChangeListener(this.listener);
            }
            this.count.add(callback);
        }
    }

    public void removeOnPropertyChangedCallback(Observable.OnPropertyChangedCallback callback) {
        super.removeOnPropertyChangedCallback(callback);
        this.count.remove(callback);
        if (this.count.isEmpty()) {
            this.all.removeChangeListener(this.listener);
            this.all = null;
            this.closable.close();
            this.closable = null;
        }
    }
}

