/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.realm;

import android.databinding.ListChangeRegistry;
import android.databinding.ObservableList;
import io.realm.OrderedCollectionChangeSet;
import io.realm.OrderedRealmCollection;
import io.realm.OrderedRealmCollectionChangeListener;
import io.realm.Realm;
import io.realm.RealmConfiguration;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmQuery;
import io.realm.RealmResults;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import xyz.truenight.databinding.realm.FindFunction;
import xyz.truenight.databinding.realm.OnApplyQuery;
import xyz.truenight.databinding.realm.RealmObservableField;

public class RealmObservableList<T extends RealmModel>
extends AbstractList<T>
implements ObservableList<T> {
    private final Class<T> cls;
    private final OnApplyQuery<T> applyQuery;
    private final RealmConfiguration realmConfig;
    private Realm realm;
    private OrderedRealmCollection<T> items;
    private final OrderedRealmCollectionChangeListener listener;
    private final ListChangeRegistry listeners = new ListChangeRegistry();
    private List<T> mirror;
    private boolean updateOnModification;
    private FindFunction<T> findFunction;

    public static <E extends RealmModel> OnApplyQuery<E> all() {
        return RealmObservableField.all();
    }

    public RealmObservableList(Class<T> cls, OnApplyQuery<T> apply) {
        this(cls, apply, null);
    }

    public RealmObservableList(RealmConfiguration configuration, Class<T> cls, OnApplyQuery<T> apply) {
        this(configuration, cls, apply, null);
    }

    public RealmObservableList(Class<T> cls, OnApplyQuery<T> apply, FindFunction<T> function) {
        this(cls, apply, function, true);
    }

    public RealmObservableList(RealmConfiguration configuration, Class<T> cls, OnApplyQuery<T> apply, FindFunction<T> function) {
        this(configuration, cls, apply, function, true);
    }

    public RealmObservableList(Class<T> cls, OnApplyQuery<T> apply, FindFunction<T> function, boolean updateOnModification) {
        this(Realm.getDefaultConfiguration(), cls, apply, function, updateOnModification);
    }

    public RealmObservableList(RealmConfiguration configuration, Class<T> cls, OnApplyQuery<T> apply, FindFunction<T> function, boolean updateOnModification) {
        this.realmConfig = configuration;
        this.cls = cls;
        this.applyQuery = apply;
        this.findFunction = function;
        this.mirror = Collections.emptyList();
        this.listener = this.createListener();
        this.updateOnModification = updateOnModification;
    }

    @Override
    @Deprecated
    public T set(int index, T element) {
        return (T)((RealmModel)super.set(index, element));
    }

    @Override
    @Deprecated
    public void clear() {
        super.clear();
    }

    @Override
    @Deprecated
    public boolean add(T t) {
        return super.add(t);
    }

    @Override
    @Deprecated
    public void add(int index, T element) {
        super.add(index, element);
    }

    @Override
    @Deprecated
    public boolean addAll(Collection<? extends T> c) {
        return super.addAll(c);
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends T> c) {
        return super.addAll(index, c);
    }

    @Override
    @Deprecated
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    @Deprecated
    public boolean remove(Object o) {
        return super.remove(o);
    }

    @Override
    @Deprecated
    public boolean removeAll(Collection<?> c) {
        return super.removeAll(c);
    }

    @Override
    @Deprecated
    public T remove(int index) {
        return (T)((RealmModel)super.remove(index));
    }

    @Override
    @Deprecated
    public boolean retainAll(Collection<?> c) {
        return super.retainAll(c);
    }

    private OrderedRealmCollectionChangeListener createListener() {
        return new OrderedRealmCollectionChangeListener(){

            public void onChange(Object collection, OrderedCollectionChangeSet changeSet) {
                OrderedCollectionChangeSet.Range[] modifications;
                OrderedCollectionChangeSet.Range[] insertions;
                RealmObservableList.this.mirror = new ArrayList(RealmObservableList.this.items);
                if (changeSet == null) {
                    RealmObservableList.this.listeners.notifyChanged((ObservableList)RealmObservableList.this);
                    return;
                }
                OrderedCollectionChangeSet.Range[] deletions = changeSet.getDeletionRanges();
                for (int i = deletions.length - 1; i >= 0; --i) {
                    OrderedCollectionChangeSet.Range[] range = deletions[i];
                    RealmObservableList.this.modCount = RealmObservableList.this.modCount + 1;
                    RealmObservableList.this.listeners.notifyRemoved((ObservableList)RealmObservableList.this, range.startIndex, range.length);
                }
                for (OrderedCollectionChangeSet.Range range : insertions = changeSet.getInsertionRanges()) {
                    RealmObservableList.this.modCount = RealmObservableList.this.modCount + 1;
                    RealmObservableList.this.listeners.notifyInserted((ObservableList)RealmObservableList.this, range.startIndex, range.length);
                }
                if (!RealmObservableList.this.updateOnModification) {
                    return;
                }
                for (OrderedCollectionChangeSet.Range range : modifications = changeSet.getChangeRanges()) {
                    RealmObservableList.this.listeners.notifyChanged((ObservableList)RealmObservableList.this, range.startIndex, range.length);
                }
            }
        };
    }

    public void addOnListChangedCallback(ObservableList.OnListChangedCallback<? extends ObservableList<T>> listener) {
        boolean first = this.listeners.isEmpty();
        this.listeners.add(listener);
        if (first) {
            this.realm = Realm.getInstance((RealmConfiguration)this.realmConfig);
            RealmQuery<T> realmQuery = this.applyQuery.onApply(this.realm.where(this.cls));
            this.items = this.findFunction == null ? realmQuery.findAllAsync() : this.findFunction.find(realmQuery);
            this.mirror = new ArrayList<T>(this.items);
            this.addRealmChangeListener();
            this.listeners.notifyChanged((ObservableList)this);
        }
    }

    public void removeOnListChangedCallback(ObservableList.OnListChangedCallback<? extends ObservableList<T>> listener) {
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.removeRealmChangeListener();
            this.items = null;
            this.mirror = Collections.emptyList();
            this.realm.close();
        }
    }

    private void addRealmChangeListener() {
        if (this.items instanceof RealmResults) {
            RealmResults results = (RealmResults)this.items;
            results.addChangeListener(this.listener);
        } else if (this.items instanceof RealmList) {
            RealmList list = (RealmList)this.items;
            list.addChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + this.items.getClass());
        }
    }

    private void removeRealmChangeListener() {
        if (this.items instanceof RealmResults) {
            RealmResults results = (RealmResults)this.items;
            results.removeChangeListener(this.listener);
        } else if (this.items instanceof RealmList) {
            RealmList list = (RealmList)this.items;
            list.removeChangeListener(this.listener);
        } else {
            throw new IllegalArgumentException("RealmCollection not supported: " + this.items.getClass());
        }
    }

    @Override
    public T get(int i) {
        return (T)((RealmModel)this.mirror.get(i));
    }

    @Override
    public int size() {
        return this.mirror.size();
    }

    static /* synthetic */ int access$300(RealmObservableList x0) {
        return x0.modCount;
    }

    static /* synthetic */ int access$600(RealmObservableList x0) {
        return x0.modCount;
    }
}

