/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.lifecycle;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import xyz.truenight.databinding.lifecycle.BindingList;
import xyz.truenight.databinding.lifecycle.BindingProvider;
import xyz.truenight.databinding.lifecycle.SingleProviderFactory;

public class ViewModelBinding
implements BindingProvider {
    private final FragmentActivity mActivity;
    private final Fragment mFragment;
    private final Class<? extends ViewModel> mVmClass;
    private final int mVariableId;
    private Factory<? extends ViewModel> mFactory;

    public ViewModelBinding(FragmentActivity activity, int variableId, Class<? extends ViewModel> vmClass) {
        this.mActivity = activity;
        this.mFragment = null;
        this.mVmClass = vmClass;
        this.mVariableId = variableId;
    }

    public <T extends ViewModel> ViewModelBinding(FragmentActivity activity, int variableId, Class<T> vmClass, Factory<T> factory) {
        this.mActivity = activity;
        this.mFragment = null;
        this.mVmClass = vmClass;
        this.mVariableId = variableId;
        this.mFactory = factory;
    }

    public ViewModelBinding(Fragment fragment, int variableId, Class<? extends ViewModel> vmClass) {
        this.mActivity = null;
        this.mFragment = fragment;
        this.mVmClass = vmClass;
        this.mVariableId = variableId;
    }

    public <T extends ViewModel> ViewModelBinding(Fragment fragment, int variableId, Class<T> vmClass, Factory<T> factory) {
        this.mActivity = null;
        this.mFragment = fragment;
        this.mVmClass = vmClass;
        this.mVariableId = variableId;
        this.mFactory = factory;
    }

    public FragmentActivity getActivity() {
        return this.mActivity;
    }

    public Fragment getFragment() {
        return this.mFragment;
    }

    public Class<? extends ViewModel> getVmClass() {
        return this.mVmClass;
    }

    public int getVariableId() {
        return this.mVariableId;
    }

    public Factory getRawFactory() {
        return this.mFactory;
    }

    public ViewModelProvider.Factory getFactory() {
        return this.mFactory == null ? null : new SingleProviderFactory<ViewModel>(this.mFactory);
    }

    @Override
    public BindingList getItems() {
        return new BindingList(this);
    }

    public static interface Factory<T extends ViewModel> {
        @NonNull
        public T create();
    }
}

