/*
 * Decompiled with CFR 0.152.
 */
package xyz.truenight.databinding.lifecycle;

import androidx.lifecycle.GenericLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import androidx.lifecycle.ViewModel;

public abstract class LifecycleTrackingViewModel
extends ViewModel {
    private int mActiveCount;

    public void registerLifecycle(final LifecycleOwner owner) {
        owner.getLifecycle().addObserver((LifecycleObserver)new GenericLifecycleObserver(){
            boolean mActive = false;

            @OnLifecycleEvent(value=Lifecycle.Event.ON_ANY)
            public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                if (source.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
                    owner.getLifecycle().removeObserver((LifecycleObserver)this);
                    return;
                }
                this.activeStateChanged(LifecycleTrackingViewModel.isActiveState(source.getLifecycle().getCurrentState()));
            }

            private void activeStateChanged(boolean active) {
                if (active == this.mActive) {
                    return;
                }
                this.mActive = active;
                boolean wasInactive = LifecycleTrackingViewModel.this.mActiveCount == 0;
                LifecycleTrackingViewModel.this.mActiveCount = LifecycleTrackingViewModel.this.mActiveCount + (active ? 1 : -1);
                if (wasInactive && active) {
                    LifecycleTrackingViewModel.this.onActive();
                }
                if (LifecycleTrackingViewModel.this.mActiveCount == 0 && !active) {
                    LifecycleTrackingViewModel.this.onInactive();
                }
            }
        });
    }

    private static boolean isActiveState(Lifecycle.State state) {
        return state.isAtLeast(Lifecycle.State.STARTED);
    }

    public abstract void onActive();

    public abstract void onInactive();
}

