/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.camera;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.RequiresApi;
import android.support.v4.content.res.ResourcesCompat;
import android.util.AttributeSet;
import android.view.View;
import java.io.File;
import xin.dlong.ocr.ui.R;
import xin.dlong.ocr.ui.camera.CameraView;
import xin.dlong.ocr.ui.camera.MaskView;

public class MaskView
extends View {
    public static final int MASK_TYPE_NONE = 0;
    public static final int MASK_TYPE_ID_CARD_FRONT = 1;
    public static final int MASK_TYPE_ID_CARD_BACK = 2;
    public static final int MASK_TYPE_BANK_CARD = 11;
    private int lineColor = -1;
    private int maskType = 1;
    private int maskColor = Color.argb((int)100, (int)0, (int)0, (int)0);
    private Paint eraser = new Paint(1);
    private Paint pen = new Paint(1);
    private Rect frame = new Rect();
    private Drawable locatorDrawable;
    private Path path = new Path();

    public void setLineColor(int lineColor) {
        this.lineColor = lineColor;
    }

    public void setMaskColor(int maskColor) {
        this.maskColor = maskColor;
    }

    public Rect getFrameRect() {
        if (this.maskType == 0) {
            return new Rect(0, 0, this.getWidth(), this.getHeight());
        }
        return new Rect(this.frame);
    }

    public Rect getFrameRectExtend() {
        Rect rc = new Rect(this.frame);
        int widthExtend = (int)((float)(this.frame.right - this.frame.left) * 0.02f);
        int heightExtend = (int)((float)(this.frame.bottom - this.frame.top) * 0.02f);
        rc.left -= widthExtend;
        rc.right += widthExtend;
        rc.top -= heightExtend;
        rc.bottom += heightExtend;
        return rc;
    }

    public void setMaskType(@MaskType int maskType) {
        this.maskType = maskType;
        switch (maskType) {
            case 1: {
                this.locatorDrawable = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.bd_ocr_id_card_locator_front, null);
                break;
            }
            case 2: {
                this.locatorDrawable = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.bd_ocr_id_card_locator_back, null);
                break;
            }
            case 11: {
                break;
            }
        }
        this.invalidate();
    }

    public int getMaskType() {
        return this.maskType;
    }

    public void setOrientation(@CameraView.Orientation int orientation) {
    }

    public MaskView(Context context) {
        super(context);
        this.setLayerType(1, null);
        this.pen.setColor(-1);
        this.pen.setStyle(Paint.Style.STROKE);
        this.pen.setStrokeWidth(6.0f);
        this.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.init();
    }

    public MaskView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setLayerType(1, null);
        this.pen.setColor(-1);
        this.pen.setStyle(Paint.Style.STROKE);
        this.pen.setStrokeWidth(6.0f);
        this.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.init();
    }

    public MaskView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        this.pen.setColor(-1);
        this.pen.setStyle(Paint.Style.STROKE);
        this.pen.setStrokeWidth(6.0f);
        this.eraser.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.init();
    }

    private void init() {
        this.locatorDrawable = ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.bd_ocr_id_card_locator_front, null);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0 && h > 0) {
            float ratio = h > w ? 0.9f : 0.72f;
            int width = (int)((float)w * ratio);
            int height = width * 400 / 620;
            int left = (w - width) / 2;
            int top = (h - height) / 2;
            int right = width + left;
            int bottom = height + top;
            this.frame.left = left;
            this.frame.top = top;
            this.frame.right = right;
            this.frame.bottom = bottom;
        }
    }

    @RequiresApi(api=21)
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int width = this.frame.width();
        int height = this.frame.height();
        int left = this.frame.left;
        int top = this.frame.top;
        int right = this.frame.right;
        int bottom = this.frame.bottom;
        canvas.drawColor(this.maskColor);
        this.fillRectRound(left, top, right, bottom, 30.0f, 30.0f, false);
        canvas.drawPath(this.path, this.pen);
        canvas.drawPath(this.path, this.eraser);
        if (this.maskType == 1) {
            this.locatorDrawable.setBounds((int)((float)left + 0.5974155f * (float)width), (int)((float)top + 0.17405063f * (float)height), (int)((float)left + 0.95725644f * (float)width), (int)((float)top + 0.7531645f * (float)height));
        } else if (this.maskType == 2) {
            this.locatorDrawable.setBounds((int)((float)left + 0.050695825f * (float)width), (int)((float)top + 0.07594936f * (float)height), (int)((float)left + 0.24850895f * (float)width), (int)((float)top + 0.41455695f * (float)height));
        }
        if (this.locatorDrawable != null) {
            this.locatorDrawable.draw(canvas);
        }
    }

    private Path fillRectRound(float left, float top, float right, float bottom, float rx, float ry, boolean conformToOriginalPost) {
        this.path.reset();
        if (rx < 0.0f) {
            rx = 0.0f;
        }
        if (ry < 0.0f) {
            ry = 0.0f;
        }
        float width = right - left;
        float height = bottom - top;
        if (rx > width / 2.0f) {
            rx = width / 2.0f;
        }
        if (ry > height / 2.0f) {
            ry = height / 2.0f;
        }
        float widthMinusCorners = width - 2.0f * rx;
        float heightMinusCorners = height - 2.0f * ry;
        this.path.moveTo(right, top + ry);
        this.path.rQuadTo(0.0f, -ry, -rx, -ry);
        this.path.rLineTo(-widthMinusCorners, 0.0f);
        this.path.rQuadTo(-rx, 0.0f, -rx, ry);
        this.path.rLineTo(0.0f, heightMinusCorners);
        if (conformToOriginalPost) {
            this.path.rLineTo(0.0f, ry);
            this.path.rLineTo(width, 0.0f);
            this.path.rLineTo(0.0f, -ry);
        } else {
            this.path.rQuadTo(0.0f, ry, rx, ry);
            this.path.rLineTo(widthMinusCorners, 0.0f);
            this.path.rQuadTo(rx, 0.0f, rx, -ry);
        }
        this.path.rLineTo(0.0f, -heightMinusCorners);
        this.path.close();
        return this.path;
    }

    private void capture(File file) {
    }
}

