/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.camera;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import xin.dlong.ocr.ui.R;
import xin.dlong.ocr.ui.camera.CameraThreadPool;
import xin.dlong.ocr.ui.camera.CameraView;
import xin.dlong.ocr.ui.camera.MaskView;
import xin.dlong.ocr.ui.camera.OCRCameraLayout;
import xin.dlong.ocr.ui.camera.PermissionCallback;
import xin.dlong.ocr.ui.crop.CropView;
import xin.dlong.ocr.ui.crop.FrameOverlayView;

public class CameraActivity
extends Activity {
    public static final String KEY_OUTPUT_FILE_PATH = "outputFilePath";
    public static final String KEY_CONTENT_TYPE = "contentType";
    public static final String KEY_NATIVE_TOKEN = "nativeToken";
    public static final String KEY_NATIVE_ENABLE = "nativeEnable";
    public static final String CONTENT_TYPE_GENERAL = "general";
    public static final String CONTENT_TYPE_ID_CARD_FRONT = "IDCardFront";
    public static final String CONTENT_TYPE_ID_CARD_BACK = "IDCardBack";
    public static final String CONTENT_TYPE_BANK_CARD = "bankCard";
    private static final int REQUEST_CODE_PICK_IMAGE = 100;
    private static final int PERMISSIONS_REQUEST_CAMERA = 800;
    private static final int PERMISSIONS_EXTERNAL_STORAGE = 801;
    private File outputFile;
    private String contentType;
    private Handler handler = new Handler();
    private OCRCameraLayout takePictureContainer;
    private OCRCameraLayout cropContainer;
    private OCRCameraLayout confirmResultContainer;
    private ImageView lightButton;
    private CameraView cameraView;
    private ImageView displayImageView;
    private CropView cropView;
    private FrameOverlayView overlayView;
    private MaskView cropMaskView;
    private ImageView takePhotoBtn;
    private PermissionCallback permissionCallback = new PermissionCallback(){

        @Override
        public boolean onRequestPermission() {
            ActivityCompat.requestPermissions((Activity)CameraActivity.this, (String[])new String[]{"android.permission.CAMERA"}, (int)800);
            return false;
        }
    };
    private View.OnClickListener albumButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (ActivityCompat.checkSelfPermission((Context)CameraActivity.this.getApplicationContext(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0 && Build.VERSION.SDK_INT >= 16) {
                ActivityCompat.requestPermissions((Activity)CameraActivity.this, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)801);
                return;
            }
            Intent intent = new Intent("android.intent.action.PICK");
            intent.setType("image/*");
            CameraActivity.this.startActivityForResult(intent, 100);
        }
    };
    private View.OnClickListener lightButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (CameraActivity.this.cameraView.getCameraControl().getFlashMode() == 0) {
                CameraActivity.this.cameraView.getCameraControl().setFlashMode(1);
            } else {
                CameraActivity.this.cameraView.getCameraControl().setFlashMode(0);
            }
            CameraActivity.this.updateFlashMode();
        }
    };
    private View.OnClickListener takeButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            CameraActivity.this.cameraView.takePicture(CameraActivity.this.outputFile, CameraActivity.this.takePictureCallback);
        }
    };
    private CameraView.OnTakePictureCallback autoTakePictureCallback = new CameraView.OnTakePictureCallback(){

        @Override
        public void onPictureTaken(final Bitmap bitmap) {
            CameraThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(CameraActivity.this.outputFile);
                        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                        bitmap.recycle();
                        fileOutputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    Intent intent = new Intent();
                    intent.putExtra(CameraActivity.KEY_CONTENT_TYPE, CameraActivity.this.contentType);
                    CameraActivity.this.setResult(-1, intent);
                    CameraActivity.this.finish();
                }
            });
        }
    };
    private CameraView.OnTakePictureCallback takePictureCallback = new CameraView.OnTakePictureCallback(){

        @Override
        public void onPictureTaken(final Bitmap bitmap) {
            CameraActivity.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    CameraActivity.this.takePictureContainer.setVisibility(4);
                    if (CameraActivity.this.cropMaskView.getMaskType() == 0) {
                        CameraActivity.this.cropView.setFilePath(CameraActivity.this.outputFile.getAbsolutePath());
                        CameraActivity.this.showCrop();
                    } else if (CameraActivity.this.cropMaskView.getMaskType() == 11) {
                        CameraActivity.this.cropView.setFilePath(CameraActivity.this.outputFile.getAbsolutePath());
                        CameraActivity.this.cropMaskView.setVisibility(4);
                        CameraActivity.this.overlayView.setVisibility(0);
                        CameraActivity.this.overlayView.setTypeWide();
                        CameraActivity.this.showCrop();
                    } else {
                        CameraActivity.this.displayImageView.setImageBitmap(bitmap);
                        CameraActivity.this.showResultConfirm();
                    }
                }
            });
        }
    };
    private View.OnClickListener cropCancelButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            CameraActivity.this.cropView.setFilePath(null);
            CameraActivity.this.showTakePicture();
        }
    };
    private View.OnClickListener cropConfirmButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            Rect rect;
            int maskType = CameraActivity.this.cropMaskView.getMaskType();
            switch (maskType) {
                case 1: 
                case 2: 
                case 11: {
                    rect = CameraActivity.this.cropMaskView.getFrameRect();
                    break;
                }
                default: {
                    rect = CameraActivity.this.overlayView.getFrameRect();
                }
            }
            Bitmap cropped = CameraActivity.this.cropView.crop(rect);
            CameraActivity.this.displayImageView.setImageBitmap(cropped);
            CameraActivity.this.cropAndConfirm();
        }
    };
    private View.OnClickListener closeButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            CameraActivity.this.setResult(0);
            CameraActivity.this.finish();
        }
    };
    private View.OnClickListener confirmButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            CameraActivity.this.doConfirmResult();
        }
    };
    private View.OnClickListener confirmCancelButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            CameraActivity.this.displayImageView.setImageBitmap(null);
            CameraActivity.this.showTakePicture();
        }
    };
    private View.OnClickListener rotateButtonOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            CameraActivity.this.cropView.rotate(90);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.bd_ocr_activity_camera);
        this.takePictureContainer = (OCRCameraLayout)this.findViewById(R.id.take_picture_container);
        this.confirmResultContainer = (OCRCameraLayout)this.findViewById(R.id.confirm_result_container);
        this.cameraView = (CameraView)this.findViewById(R.id.camera_view);
        this.cameraView.getCameraControl().setPermissionCallback(this.permissionCallback);
        this.lightButton = (ImageView)this.findViewById(R.id.light_button);
        this.lightButton.setOnClickListener(this.lightButtonOnClickListener);
        this.takePhotoBtn = (ImageView)this.findViewById(R.id.take_photo_button);
        this.findViewById(R.id.album_button).setOnClickListener(this.albumButtonOnClickListener);
        this.takePhotoBtn.setOnClickListener(this.takeButtonOnClickListener);
        this.findViewById(R.id.close_button).setOnClickListener(this.closeButtonOnClickListener);
        this.displayImageView = (ImageView)this.findViewById(R.id.display_image_view);
        this.confirmResultContainer.findViewById(R.id.confirm_button).setOnClickListener(this.confirmButtonOnClickListener);
        this.confirmResultContainer.findViewById(R.id.cancel_button).setOnClickListener(this.confirmCancelButtonOnClickListener);
        this.findViewById(R.id.rotate_button).setOnClickListener(this.rotateButtonOnClickListener);
        this.cropView = (CropView)this.findViewById(R.id.crop_view);
        this.cropContainer = (OCRCameraLayout)this.findViewById(R.id.crop_container);
        this.overlayView = (FrameOverlayView)this.findViewById(R.id.overlay_view);
        this.cropContainer.findViewById(R.id.confirm_button).setOnClickListener(this.cropConfirmButtonListener);
        this.cropMaskView = (MaskView)this.cropContainer.findViewById(R.id.crop_mask_view);
        this.cropContainer.findViewById(R.id.cancel_button).setOnClickListener(this.cropCancelButtonListener);
        this.setOrientation(this.getResources().getConfiguration());
        this.initParams();
        this.cameraView.setAutoPictureCallback(this.autoTakePictureCallback);
    }

    protected void onStart() {
        super.onStart();
        this.cameraView.start();
    }

    protected void onStop() {
        super.onStop();
        this.cameraView.stop();
    }

    private void initParams() {
        int maskType;
        String outputPath = this.getIntent().getStringExtra(KEY_OUTPUT_FILE_PATH);
        if (outputPath != null) {
            this.outputFile = new File(outputPath);
        }
        this.contentType = this.getIntent().getStringExtra(KEY_CONTENT_TYPE);
        if (this.contentType == null) {
            this.contentType = CONTENT_TYPE_GENERAL;
        }
        switch (this.contentType) {
            case "IDCardFront": {
                maskType = 1;
                this.overlayView.setVisibility(4);
                break;
            }
            case "IDCardBack": {
                maskType = 2;
                this.overlayView.setVisibility(4);
                break;
            }
            case "bankCard": {
                maskType = 11;
                this.overlayView.setVisibility(4);
                break;
            }
            default: {
                maskType = 0;
                this.cropMaskView.setVisibility(4);
            }
        }
        this.cameraView.setMaskType(maskType, (Context)this);
        this.cropMaskView.setMaskType(maskType);
    }

    private void showTakePicture() {
        this.cameraView.getCameraControl().resume();
        this.updateFlashMode();
        this.takePictureContainer.setVisibility(0);
        this.confirmResultContainer.setVisibility(4);
        this.cropContainer.setVisibility(4);
    }

    private void showCrop() {
        this.cameraView.getCameraControl().pause();
        this.updateFlashMode();
        this.takePictureContainer.setVisibility(4);
        this.confirmResultContainer.setVisibility(4);
        this.cropContainer.setVisibility(0);
    }

    private void showResultConfirm() {
        this.cameraView.getCameraControl().pause();
        this.updateFlashMode();
        this.takePictureContainer.setVisibility(4);
        this.confirmResultContainer.setVisibility(0);
        this.cropContainer.setVisibility(4);
    }

    private void updateFlashMode() {
        int flashMode = this.cameraView.getCameraControl().getFlashMode();
        if (flashMode == 1) {
            this.lightButton.setImageResource(R.drawable.bd_ocr_light_on);
        } else {
            this.lightButton.setImageResource(R.drawable.bd_ocr_light_off);
        }
    }

    private void cropAndConfirm() {
        this.cameraView.getCameraControl().pause();
        this.updateFlashMode();
        this.doConfirmResult();
    }

    private void doConfirmResult() {
        CameraThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(CameraActivity.this.outputFile);
                    Bitmap bitmap = ((BitmapDrawable)CameraActivity.this.displayImageView.getDrawable()).getBitmap();
                    bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                Intent intent = new Intent();
                intent.putExtra(CameraActivity.KEY_CONTENT_TYPE, CameraActivity.this.contentType);
                CameraActivity.this.setResult(-1, intent);
                CameraActivity.this.finish();
            }
        });
    }

    private String getRealPathFromURI(Uri contentURI) {
        String result;
        Cursor cursor = this.getContentResolver().query(contentURI, null, null, null, null);
        if (cursor == null) {
            result = contentURI.getPath();
        } else {
            cursor.moveToFirst();
            int idx = cursor.getColumnIndex("_data");
            result = cursor.getString(idx);
            cursor.close();
        }
        return result;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.setOrientation(newConfig);
    }

    private void setOrientation(Configuration newConfig) {
        int orientation;
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        int cameraViewOrientation = 0;
        switch (newConfig.orientation) {
            case 1: {
                cameraViewOrientation = 0;
                orientation = OCRCameraLayout.ORIENTATION_PORTRAIT;
                break;
            }
            case 2: {
                orientation = OCRCameraLayout.ORIENTATION_HORIZONTAL;
                if (rotation == 0 || rotation == 1) {
                    cameraViewOrientation = 90;
                    break;
                }
                cameraViewOrientation = 270;
                break;
            }
            default: {
                orientation = OCRCameraLayout.ORIENTATION_PORTRAIT;
                this.cameraView.setOrientation(0);
            }
        }
        this.takePictureContainer.setOrientation(orientation);
        this.cameraView.setOrientation(cameraViewOrientation);
        this.cropContainer.setOrientation(orientation);
        this.confirmResultContainer.setOrientation(orientation);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 100) {
            if (resultCode == -1) {
                Uri uri = data.getData();
                this.cropView.setFilePath(this.getRealPathFromURI(uri));
                this.showCrop();
            } else {
                this.cameraView.getCameraControl().resume();
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 800: {
                if (grantResults.length > 0 && grantResults[0] == 0) {
                    this.cameraView.getCameraControl().refreshPermission();
                    break;
                }
                Toast.makeText((Context)this.getApplicationContext(), (int)R.string.camera_permission_required, (int)1).show();
                break;
            }
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cameraView.release();
    }
}

