/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.crop;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.WindowManager;
import java.io.IOException;
import xin.dlong.ocr.ui.util.ImageUtil;

public class CropView
extends View {
    private float setMinimumScale = 0.2f;
    private float maximumScale = 4.0f;
    private float[] matrixArray = new float[9];
    private Matrix matrix = new Matrix();
    private Bitmap bitmap;
    private GestureDetector gestureDetector;
    private ScaleGestureDetector scaleGestureDetector;
    private ScaleGestureDetector.OnScaleGestureListener onScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            CropView.this.scale(detector);
            return true;
        }

        public boolean onScaleBegin(ScaleGestureDetector detector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            CropView.this.matrix.postScale(scale, scale);
            CropView.this.invalidate();
        }
    };
    int rotation = 0;
    private Rect restrictBound;

    public CropView(Context context) {
        super(context);
        this.init();
    }

    public CropView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CropView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void setFilePath(String path) {
        if (this.bitmap != null && !this.bitmap.isRecycled()) {
            this.bitmap.recycle();
        }
        if (path == null) {
            return;
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        Bitmap original = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        try {
            ExifInterface exif = new ExifInterface(path);
            int rotation = exif.getAttributeInt("Orientation", 1);
            Matrix matrix = new Matrix();
            int rotationInDegrees = ImageUtil.exifToDegrees(rotation);
            if ((float)rotation != 0.0f) {
                matrix.preRotate((float)rotationInDegrees);
            }
            int maxPreviewImageSize = 2560;
            int min = Math.min(options.outWidth, options.outHeight);
            min = Math.min(min, maxPreviewImageSize);
            WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
            Point screenSize = new Point();
            windowManager.getDefaultDisplay().getSize(screenSize);
            min = Math.min(min, screenSize.x * 2 / 3);
            options.inSampleSize = ImageUtil.calculateInSampleSize(options, min, min);
            options.inScaled = true;
            options.inDensity = options.outWidth;
            options.inTargetDensity = min * options.inSampleSize;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inJustDecodeBounds = false;
            this.bitmap = BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.bitmap = original;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        this.setBitmap(this.bitmap);
    }

    private void setBitmap(Bitmap bitmap) {
        this.bitmap = bitmap;
        this.matrix.reset();
        this.centerImage(this.getWidth(), this.getHeight());
        this.rotation = 0;
        this.invalidate();
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.centerImage(w, h);
        this.invalidate();
    }

    public Bitmap crop(Rect frame) {
        float scale = this.getScale();
        float[] src = new float[]{frame.left, frame.top};
        float[] desc = new float[]{0.0f, 0.0f};
        Matrix invertedMatrix = new Matrix();
        this.matrix.invert(invertedMatrix);
        invertedMatrix.mapPoints(desc, src);
        Matrix matrix = new Matrix();
        int width = (int)((float)frame.width() / scale);
        int height = (int)((float)frame.height() / scale);
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(bitmap);
        Bitmap originalBitmap = this.bitmap;
        matrix.postTranslate(-desc[0], -desc[1]);
        canvas.drawBitmap(originalBitmap, matrix, null);
        return bitmap;
    }

    public void setMinimumScale(float setMinimumScale) {
        this.setMinimumScale = setMinimumScale;
    }

    public void setMaximumScale(float maximumScale) {
        this.maximumScale = maximumScale;
    }

    private void init() {
        this.scaleGestureDetector = new ScaleGestureDetector(this.getContext(), this.onScaleGestureListener);
        this.gestureDetector = new GestureDetector(this.getContext(), new GestureDetector.OnGestureListener(){

            public boolean onDown(MotionEvent e) {
                return true;
            }

            public void onShowPress(MotionEvent e) {
            }

            public boolean onSingleTapUp(MotionEvent e) {
                return false;
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                CropView.this.translate(distanceX, distanceY);
                return true;
            }

            public void onLongPress(MotionEvent e) {
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                return false;
            }
        });
    }

    public void rotate(int degrees) {
        Matrix matrix = new Matrix();
        int dx = this.bitmap.getWidth() / 2;
        int dy = this.bitmap.getHeight() / 2;
        matrix.postTranslate((float)(-dx), (float)(-dy));
        matrix.postRotate((float)degrees);
        matrix.postTranslate((float)dy, (float)dx);
        Bitmap scaledBitmap = this.bitmap;
        Bitmap rotatedBitmap = Bitmap.createBitmap((int)scaledBitmap.getHeight(), (int)scaledBitmap.getWidth(), (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas canvas = new Canvas(rotatedBitmap);
        canvas.drawBitmap(this.bitmap, matrix, null);
        this.bitmap.recycle();
        this.bitmap = rotatedBitmap;
        this.centerImage(this.getWidth(), this.getHeight());
        this.invalidate();
    }

    private void translate(float distanceX, float distanceY) {
        this.matrix.getValues(this.matrixArray);
        float left = this.matrixArray[2];
        float top = this.matrixArray[5];
        Rect bound = this.getRestrictedBound();
        if (bound != null) {
            float scale = this.getScale();
            float right = left + (float)((int)((float)this.bitmap.getWidth() / scale));
            float bottom = top + (float)((int)((float)this.bitmap.getHeight() / scale));
            if (left - distanceX > (float)bound.left) {
                distanceX = left - (float)bound.left;
            }
            if (top - distanceY > (float)bound.top) {
                distanceY = top - (float)bound.top;
            }
            if (distanceX > 0.0f && right - distanceX < (float)bound.right) {
                distanceX = right - (float)bound.right;
            }
            if (distanceY > 0.0f && bottom - distanceY < (float)bound.bottom) {
                distanceY = bottom - (float)bound.bottom;
            }
        }
        this.matrix.postTranslate(-distanceX, -distanceY);
        this.invalidate();
    }

    private void scale(ScaleGestureDetector detector) {
        float scale = detector.getScaleFactor();
        float currentScale = this.getScale();
        if (currentScale * scale < this.setMinimumScale) {
            scale = this.setMinimumScale / currentScale;
        }
        if (currentScale * scale > this.maximumScale) {
            scale = this.maximumScale / currentScale;
        }
        this.matrix.postScale(scale, scale, detector.getFocusX(), detector.getFocusY());
        this.invalidate();
    }

    private void centerImage(int width, int height) {
        if (width <= 0 || height <= 0 || this.bitmap == null) {
            return;
        }
        float widthRatio = 1.0f * (float)height / (float)this.bitmap.getHeight();
        float heightRatio = 1.0f * (float)width / (float)this.bitmap.getWidth();
        float ratio = Math.min(widthRatio, heightRatio);
        float dx = (width - this.bitmap.getWidth()) / 2;
        float dy = (height - this.bitmap.getHeight()) / 2;
        this.matrix.setTranslate(0.0f, 0.0f);
        this.matrix.setScale(ratio, ratio, (float)(this.bitmap.getWidth() / 2), (float)(this.bitmap.getHeight() / 2));
        this.matrix.postTranslate(dx, dy);
        this.invalidate();
    }

    private float getScale() {
        this.matrix.getValues(this.matrixArray);
        float scale = this.matrixArray[0];
        if ((double)Math.abs(scale) <= 0.1) {
            scale = this.matrixArray[1];
        }
        return Math.abs(scale);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.bitmap != null) {
            canvas.drawBitmap(this.bitmap, this.matrix, null);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean result = this.scaleGestureDetector.onTouchEvent(event);
        result = this.gestureDetector.onTouchEvent(event) || result;
        return result || super.onTouchEvent(event);
    }

    private Rect getRestrictedBound() {
        return this.restrictBound;
    }

    public void setRestrictBound(Rect rect) {
        this.restrictBound = rect;
    }
}

