/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.camera;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import xin.dlong.ocr.ui.R;

public class OCRCameraLayout
extends FrameLayout {
    public static int ORIENTATION_PORTRAIT = 0;
    public static int ORIENTATION_HORIZONTAL = 1;
    private int orientation = ORIENTATION_PORTRAIT;
    private View contentView;
    private View centerView;
    private View leftDownView;
    private View rightUpView;
    private int contentViewId;
    private int centerViewId;
    private int leftDownViewId;
    private int rightUpViewId;
    private Rect backgroundRect;
    private Paint paint;

    public void setOrientation(int orientation) {
        if (this.orientation == orientation) {
            return;
        }
        this.orientation = orientation;
        this.requestLayout();
    }

    public OCRCameraLayout(Context context) {
        super(context);
        this.setWillNotDraw(false);
        this.backgroundRect = new Rect();
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(Color.argb((int)83, (int)0, (int)0, (int)0));
    }

    public OCRCameraLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setWillNotDraw(false);
        this.backgroundRect = new Rect();
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(Color.argb((int)83, (int)0, (int)0, (int)0));
        this.parseAttrs(attrs);
    }

    public OCRCameraLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setWillNotDraw(false);
        this.backgroundRect = new Rect();
        this.paint = new Paint();
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(Color.argb((int)83, (int)0, (int)0, (int)0));
        this.parseAttrs(attrs);
    }

    private void parseAttrs(AttributeSet attrs) {
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.OCRCameraLayout, 0, 0);
        try {
            this.contentViewId = a.getResourceId(R.styleable.OCRCameraLayout_contentView, -1);
            this.centerViewId = a.getResourceId(R.styleable.OCRCameraLayout_centerView, -1);
            this.leftDownViewId = a.getResourceId(R.styleable.OCRCameraLayout_leftDownView, -1);
            this.rightUpViewId = a.getResourceId(R.styleable.OCRCameraLayout_rightUpView, -1);
        }
        finally {
            a.recycle();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.contentView = this.findViewById(this.contentViewId);
        if (this.centerViewId != -1) {
            this.centerView = this.findViewById(this.centerViewId);
        }
        this.leftDownView = this.findViewById(this.leftDownViewId);
        this.rightUpView = this.findViewById(this.rightUpViewId);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.getWidth();
        int height = this.getHeight();
        ViewGroup.MarginLayoutParams leftDownViewLayoutParams = (ViewGroup.MarginLayoutParams)this.leftDownView.getLayoutParams();
        ViewGroup.MarginLayoutParams rightUpViewLayoutParams = (ViewGroup.MarginLayoutParams)this.rightUpView.getLayoutParams();
        if (r < b) {
            int top;
            int left;
            int contentHeight = width * 4 / 3;
            int heightLeft = height - contentHeight;
            this.contentView.layout(l, t, r, contentHeight);
            this.backgroundRect.left = 0;
            this.backgroundRect.top = contentHeight;
            this.backgroundRect.right = width;
            this.backgroundRect.bottom = height;
            if (this.centerView != null) {
                left = (width - this.centerView.getMeasuredWidth()) / 2;
                top = contentHeight + (heightLeft - this.centerView.getMeasuredHeight()) / 2;
                this.centerView.layout(left, top, left + this.centerView.getMeasuredWidth(), top + this.centerView.getMeasuredHeight());
            }
            left = leftDownViewLayoutParams.leftMargin;
            top = contentHeight + (heightLeft - this.leftDownView.getMeasuredHeight()) / 2;
            this.leftDownView.layout(left, top, left + this.leftDownView.getMeasuredWidth(), top + this.leftDownView.getMeasuredHeight());
            left = width - this.rightUpView.getMeasuredWidth() - rightUpViewLayoutParams.rightMargin;
            top = contentHeight + (heightLeft - this.rightUpView.getMeasuredHeight()) / 2;
            this.rightUpView.layout(left, top, left + this.rightUpView.getMeasuredWidth(), top + this.rightUpView.getMeasuredHeight());
        } else {
            int top;
            int left;
            int contentWidth = height * 4 / 3;
            int widthLeft = width - contentWidth;
            this.contentView.layout(l, t, contentWidth, height);
            this.backgroundRect.left = contentWidth;
            this.backgroundRect.top = 0;
            this.backgroundRect.right = width;
            this.backgroundRect.bottom = height;
            if (this.centerView != null) {
                left = contentWidth + (widthLeft - this.centerView.getMeasuredWidth()) / 2;
                top = (height - this.centerView.getMeasuredHeight()) / 2;
                this.centerView.layout(left, top, left + this.centerView.getMeasuredWidth(), top + this.centerView.getMeasuredHeight());
            }
            left = contentWidth + (widthLeft - this.leftDownView.getMeasuredWidth()) / 2;
            top = height - this.leftDownView.getMeasuredHeight() - leftDownViewLayoutParams.bottomMargin;
            this.leftDownView.layout(left, top, left + this.leftDownView.getMeasuredWidth(), top + this.leftDownView.getMeasuredHeight());
            left = contentWidth + (widthLeft - this.rightUpView.getMeasuredWidth()) / 2;
            top = rightUpViewLayoutParams.topMargin;
            this.rightUpView.layout(left, top, left + this.rightUpView.getMeasuredWidth(), top + this.rightUpView.getMeasuredHeight());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(this.backgroundRect, this.paint);
    }
}

