/*
 * Decompiled with CFR 0.152.
 */
package xin.dlong.ocr.ui.camera;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.WindowManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import xin.dlong.ocr.ui.camera.CameraView;
import xin.dlong.ocr.ui.camera.ICameraControl;
import xin.dlong.ocr.ui.camera.PermissionCallback;

@TargetApi(value=21)
public class Camera2Control
implements ICameraControl {
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();
    private static final int MAX_PREVIEW_SIZE = 2048;
    private static final int STATE_PREVIEW = 0;
    private static final int STATE_WAITING_FOR_LOCK = 1;
    private static final int STATE_WAITING_FOR_CAPTURE = 2;
    private static final int STATE_CAPTURING = 3;
    private static final int STATE_PICTURE_TAKEN = 4;
    private static final int MAX_PREVIEW_WIDTH = 1920;
    private static final int MAX_PREVIEW_HEIGHT = 1080;
    private int flashMode;
    private int orientation = 0;
    private int state = 0;
    private Context context;
    private ICameraControl.OnTakePictureCallback onTakePictureCallback;
    private PermissionCallback permissionCallback;
    private String cameraId;
    private TextureView textureView;
    private Size previewSize;
    private Rect previewFrame = new Rect();
    private HandlerThread backgroundThread;
    private Handler backgroundHandler;
    private ImageReader imageReader;
    private CameraCaptureSession captureSession;
    private CameraDevice cameraDevice;
    private CaptureRequest.Builder previewRequestBuilder;
    private CaptureRequest previewRequest;
    private Semaphore cameraLock = new Semaphore(1);
    private int sensorOrientation;
    private final TextureView.SurfaceTextureListener surfaceTextureListener = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
            Camera2Control.this.openCamera(width, height);
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
            Camera2Control.this.configureTransform(width, height);
            ((Camera2Control)Camera2Control.this).previewFrame.left = 0;
            ((Camera2Control)Camera2Control.this).previewFrame.top = 0;
            ((Camera2Control)Camera2Control.this).previewFrame.right = width;
            ((Camera2Control)Camera2Control.this).previewFrame.bottom = height;
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
            Camera2Control.this.stop();
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture texture) {
        }
    };
    private final CameraDevice.StateCallback deviceStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(@NonNull CameraDevice cameraDevice) {
            Camera2Control.this.cameraLock.release();
            Camera2Control.this.cameraDevice = cameraDevice;
            Camera2Control.this.createCameraPreviewSession();
        }

        public void onDisconnected(@NonNull CameraDevice cameraDevice) {
            Camera2Control.this.cameraLock.release();
            cameraDevice.close();
            Camera2Control.this.cameraDevice = null;
        }

        public void onError(@NonNull CameraDevice cameraDevice, int error) {
            Camera2Control.this.cameraLock.release();
            cameraDevice.close();
            Camera2Control.this.cameraDevice = null;
        }
    };
    private final ImageReader.OnImageAvailableListener onImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader reader) {
            if (Camera2Control.this.onTakePictureCallback != null) {
                Image image = reader.acquireNextImage();
                ByteBuffer buffer = image.getPlanes()[0].getBuffer();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                image.close();
                Camera2Control.this.onTakePictureCallback.onPictureTaken(bytes);
            }
        }
    };
    private CameraCaptureSession.CaptureCallback captureCallback = new CameraCaptureSession.CaptureCallback(){

        private void process(CaptureResult result) {
            block0 : switch (Camera2Control.this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (afState == null) {
                        Camera2Control.this.captureStillPicture();
                        return;
                    }
                    switch (afState) {
                        case 2: 
                        case 4: 
                        case 5: {
                            Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                            if (aeState == null || aeState == 2) {
                                Camera2Control.this.captureStillPicture();
                                break block0;
                            }
                            Camera2Control.this.runPreCaptureSequence();
                            break block0;
                        }
                    }
                    Camera2Control.this.captureStillPicture();
                    break;
                }
                case 2: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState == null || aeState == 5 || aeState == 4) {
                        Camera2Control.this.state = 3;
                        break;
                    }
                    if (aeState != 2) break;
                    Camera2Control.this.captureStillPicture();
                    break;
                }
                case 3: {
                    Integer aeState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (aeState != null && aeState == 5) break;
                    Camera2Control.this.captureStillPicture();
                    break;
                }
            }
        }

        public void onCaptureProgressed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }
    };
    private Comparator<Size> sizeComparator = new Comparator<Size>(){

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    };

    @Override
    public void setDetectCallback(ICameraControl.OnDetectPictureCallback callback) {
    }

    @Override
    public AtomicBoolean getAbortingScan() {
        return null;
    }

    @Override
    public void start() {
        this.startBackgroundThread();
        if (this.textureView.isAvailable()) {
            this.openCamera(this.textureView.getWidth(), this.textureView.getHeight());
            this.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
        } else {
            this.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
        }
    }

    @Override
    public void stop() {
        this.textureView.setSurfaceTextureListener(null);
        this.closeCamera();
        this.stopBackgroundThread();
    }

    @Override
    public void pause() {
        this.setFlashMode(0);
    }

    @Override
    public void resume() {
        this.state = 0;
    }

    @Override
    public View getDisplayView() {
        return this.textureView;
    }

    @Override
    public Rect getPreviewFrame() {
        return this.previewFrame;
    }

    @Override
    public void takePicture(ICameraControl.OnTakePictureCallback callback) {
        this.onTakePictureCallback = callback;
        this.lockFocus();
    }

    @Override
    public void setPermissionCallback(PermissionCallback callback) {
        this.permissionCallback = callback;
    }

    @Override
    public void setDisplayOrientation(@CameraView.Orientation int displayOrientation) {
        this.orientation = displayOrientation / 90;
    }

    @Override
    public void refreshPermission() {
        this.openCamera(this.textureView.getWidth(), this.textureView.getHeight());
    }

    @Override
    public void setFlashMode(@ICameraControl.FlashMode int flashMode) {
        if (this.flashMode == flashMode) {
            return;
        }
        this.flashMode = flashMode;
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            this.updateFlashMode(flashMode, this.previewRequestBuilder);
            this.previewRequest = this.previewRequestBuilder.build();
            this.captureSession.setRepeatingRequest(this.previewRequest, this.captureCallback, this.backgroundHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int getFlashMode() {
        return this.flashMode;
    }

    public Camera2Control(Context activity) {
        this.context = activity;
        this.textureView = new TextureView(activity);
    }

    private void openCamera(int width, int height) {
        if (ContextCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CAMERA") != 0) {
            this.requestCameraPermission();
            return;
        }
        this.setUpCameraOutputs(width, height);
        this.configureTransform(width, height);
        CameraManager manager = (CameraManager)this.context.getSystemService("camera");
        try {
            if (!this.cameraLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            manager.openCamera(this.cameraId, this.deviceStateCallback, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", e);
        }
    }

    private void createCameraPreviewSession() {
        try {
            SurfaceTexture texture = this.textureView.getSurfaceTexture();
            assert (texture != null);
            texture.setDefaultBufferSize(this.previewSize.getWidth(), this.previewSize.getHeight());
            Surface surface = new Surface(texture);
            this.previewRequestBuilder = this.cameraDevice.createCaptureRequest(1);
            this.previewRequestBuilder.addTarget(surface);
            this.updateFlashMode(this.flashMode, this.previewRequestBuilder);
            this.cameraDevice.createCaptureSession(Arrays.asList(surface, this.imageReader.getSurface()), new CameraCaptureSession.StateCallback(){

                public void onConfigured(@NonNull CameraCaptureSession cameraCaptureSession) {
                    if (null == Camera2Control.this.cameraDevice) {
                        return;
                    }
                    Camera2Control.this.captureSession = cameraCaptureSession;
                    try {
                        Camera2Control.this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                        Camera2Control.this.previewRequest = Camera2Control.this.previewRequestBuilder.build();
                        Camera2Control.this.captureSession.setRepeatingRequest(Camera2Control.this.previewRequest, Camera2Control.this.captureCallback, Camera2Control.this.backgroundHandler);
                    }
                    catch (CameraAccessException e) {
                        e.printStackTrace();
                    }
                }

                public void onConfigureFailed(@NonNull CameraCaptureSession cameraCaptureSession) {
                }
            }, null);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private Size getOptimalSize(Size[] choices, int textureViewWidth, int textureViewHeight, int maxWidth, int maxHeight, Size aspectRatio) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        ArrayList<Size> notBigEnough = new ArrayList<Size>();
        int w = aspectRatio.getWidth();
        int h = aspectRatio.getHeight();
        for (Size option : choices) {
            if (option.getWidth() > maxWidth || option.getHeight() > maxHeight || option.getHeight() != option.getWidth() * h / w) continue;
            if (option.getWidth() >= textureViewWidth && option.getHeight() >= textureViewHeight) {
                bigEnough.add(option);
                continue;
            }
            notBigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, this.sizeComparator);
        }
        for (Size option : choices) {
            if (option.getWidth() < maxWidth || option.getHeight() < maxHeight) continue;
            return option;
        }
        if (notBigEnough.size() > 0) {
            return Collections.max(notBigEnough, this.sizeComparator);
        }
        return choices[0];
    }

    private void requestCameraPermission() {
        if (this.permissionCallback != null) {
            this.permissionCallback.onRequestPermission();
        }
    }

    private void setUpCameraOutputs(int width, int height) {
        CameraManager manager = (CameraManager)this.context.getSystemService("camera");
        try {
            for (String cameraId : manager.getCameraIdList()) {
                StreamConfigurationMap map;
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                Integer facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (facing != null && facing == 0 || (map = (StreamConfigurationMap)characteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)) == null) continue;
                WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
                Point screenSize = new Point();
                windowManager.getDefaultDisplay().getSize(screenSize);
                int maxImageSize = Math.max(2048, screenSize.y * 3 / 2);
                Size size = this.getOptimalSize(map.getOutputSizes(256), this.textureView.getWidth(), this.textureView.getHeight(), maxImageSize, maxImageSize, new Size(4, 3));
                this.imageReader = ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)256, (int)1);
                this.imageReader.setOnImageAvailableListener(this.onImageAvailableListener, this.backgroundHandler);
                int displayRotation = this.orientation;
                this.sensorOrientation = (Integer)characteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
                boolean swappedDimensions = false;
                switch (displayRotation) {
                    case 0: 
                    case 2: {
                        if (this.sensorOrientation != 90 && this.sensorOrientation != 270) break;
                        swappedDimensions = true;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.sensorOrientation != 0 && this.sensorOrientation != 180) break;
                        swappedDimensions = true;
                        break;
                    }
                }
                int rotatedPreviewWidth = width;
                int rotatedPreviewHeight = height;
                int maxPreviewWidth = screenSize.x;
                int maxPreviewHeight = screenSize.y;
                if (swappedDimensions) {
                    rotatedPreviewWidth = height;
                    rotatedPreviewHeight = width;
                    maxPreviewWidth = screenSize.y;
                    maxPreviewHeight = screenSize.x;
                }
                maxPreviewWidth = Math.min(maxPreviewWidth, 1920);
                maxPreviewHeight = Math.min(maxPreviewHeight, 1080);
                this.previewSize = this.getOptimalSize(map.getOutputSizes(SurfaceTexture.class), rotatedPreviewWidth, rotatedPreviewHeight, maxPreviewWidth, maxPreviewHeight, size);
                this.cameraId = cameraId;
                return;
            }
        }
        catch (CameraAccessException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void closeCamera() {
        try {
            this.cameraLock.acquire();
            if (null != this.captureSession) {
                this.captureSession.close();
                this.captureSession = null;
            }
            if (null != this.cameraDevice) {
                this.cameraDevice.close();
                this.cameraDevice = null;
            }
            if (null != this.imageReader) {
                this.imageReader.close();
                this.imageReader = null;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera closing.", e);
        }
        finally {
            this.cameraLock.release();
        }
    }

    private void startBackgroundThread() {
        this.backgroundThread = new HandlerThread("ocr_camera");
        this.backgroundThread.start();
        this.backgroundHandler = new Handler(this.backgroundThread.getLooper());
    }

    private void stopBackgroundThread() {
        if (this.backgroundThread != null) {
            this.backgroundThread.quitSafely();
            this.backgroundThread = null;
            this.backgroundHandler = null;
        }
    }

    private void configureTransform(int viewWidth, int viewHeight) {
        if (null == this.textureView || null == this.previewSize || null == this.context) {
            return;
        }
        int rotation = this.orientation;
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.previewSize.getHeight(), (float)this.previewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == rotation || 3 == rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)this.previewSize.getHeight(), (float)viewWidth / (float)this.previewSize.getWidth());
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        } else if (2 == rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        this.textureView.setTransform(matrix);
    }

    private void lockFocus() {
        if (this.captureSession != null && this.state == 0) {
            try {
                this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                this.state = 1;
                this.captureSession.capture(this.previewRequestBuilder.build(), this.captureCallback, this.backgroundHandler);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void runPreCaptureSequence() {
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
            this.state = 2;
            this.captureSession.capture(this.previewRequestBuilder.build(), this.captureCallback, this.backgroundHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void captureStillPicture() {
        try {
            if (null == this.context || null == this.cameraDevice) {
                return;
            }
            CaptureRequest.Builder captureBuilder = this.cameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(this.imageReader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)this.getOrientation(this.orientation));
            this.updateFlashMode(this.flashMode, captureBuilder);
            CameraCaptureSession.CaptureCallback captureCallback = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureCompleted(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
                    Camera2Control.this.unlockFocus();
                }

                public void onCaptureFailed(@NonNull CameraCaptureSession session, @NonNull CaptureRequest request, @NonNull CaptureFailure failure) {
                    super.onCaptureFailed(session, request, failure);
                }
            };
            this.captureSession.stopRepeating();
            this.captureSession.capture(captureBuilder.build(), captureCallback, this.backgroundHandler);
            this.state = 4;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private int getOrientation(int rotation) {
        return (ORIENTATIONS.get(rotation) + this.sensorOrientation + 270) % 360;
    }

    private void unlockFocus() {
        try {
            this.previewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
            this.captureSession.capture(this.previewRequestBuilder.build(), this.captureCallback, this.backgroundHandler);
            this.state = 0;
            this.captureSession.setRepeatingRequest(this.previewRequest, this.captureCallback, this.backgroundHandler);
            this.textureView.setSurfaceTextureListener(this.surfaceTextureListener);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    private void updateFlashMode(@ICameraControl.FlashMode int flashMode, CaptureRequest.Builder builder) {
        switch (flashMode) {
            case 1: {
                builder.set(CaptureRequest.FLASH_MODE, (Object)2);
                break;
            }
            case 0: {
                builder.set(CaptureRequest.FLASH_MODE, (Object)0);
                break;
            }
            default: {
                builder.set(CaptureRequest.FLASH_MODE, (Object)1);
            }
        }
    }

    static {
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
    }
}

