/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeoutException;

class RetryTask {
    private Callable<Boolean> action;
    private Duration timeout;
    private Duration pollingInterval;

    private RetryTask(Callable<Boolean> action) {
        this.action = action;
    }

    public static RetryTask attempt(Callable<Boolean> action) {
        return new RetryTask(action);
    }

    public RetryTask untilSuccess() throws TimeoutException, InterruptedException {
        this.checkState(this.timeout == null, "timeout has not been configured");
        this.checkState(this.pollingInterval == null, "polling interval has not been configured");
        long startTime = System.currentTimeMillis();
        try {
            while (!this.action.call().booleanValue()) {
                if (RetryTask.timedOut(this.timeout, startTime)) {
                    throw new TimeoutException(String.format("Timed out after waiting %s ms, with timeout %s ms", System.currentTimeMillis() - startTime, this.timeout.toMillis()));
                }
                Thread.sleep(this.pollingInterval.toMillis());
            }
        }
        catch (InterruptedException | RuntimeException | TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    private void checkState(boolean condition, String message) {
        if (condition) {
            throw new IllegalStateException(message);
        }
    }

    public <R> R thenReturn(Callable<R> result) {
        try {
            return result.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void execute() throws TimeoutException, InterruptedException {
        this.untilSuccess();
    }

    private static boolean timedOut(Duration timeout, long startTime) {
        long currentDuration = System.currentTimeMillis() - startTime;
        return currentDuration >= timeout.toMillis();
    }

    public RetryTask withTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public RetryTask withPollingInterval(Duration pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }
}

