/*
 * Decompiled with CFR 0.152.
 */
package uk.sky.cqlmigrate;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.WriteTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.sky.cqlmigrate.LockingMechanism;
import uk.sky.cqlmigrate.exception.CannotAcquireLockException;
import uk.sky.cqlmigrate.exception.CannotReleaseLockException;

class CassandraLockingMechanism
extends LockingMechanism {
    private static final Logger log = LoggerFactory.getLogger(CassandraLockingMechanism.class);
    private final Session session;
    private PreparedStatement insertLockQuery;
    private PreparedStatement deleteLockQuery;
    private boolean isRetryAfterWriteTimeout;

    public CassandraLockingMechanism(Session session, String keyspace) {
        super(keyspace + ".schema_migration");
        this.session = session;
    }

    @Override
    public void init() throws CannotAcquireLockException {
        super.init();
        try {
            this.insertLockQuery = this.session.prepare("INSERT INTO cqlmigrate.locks (name, client) VALUES (?, ?) IF NOT EXISTS");
            this.deleteLockQuery = this.session.prepare("DELETE FROM cqlmigrate.locks WHERE name = ? IF client = ?");
        }
        catch (DriverException e) {
            throw new CannotAcquireLockException("Query to prepare locks queries failed", e);
        }
    }

    @Override
    public boolean acquire(String clientId) throws CannotAcquireLockException {
        try {
            ResultSet resultSet = this.session.execute((Statement)this.insertLockQuery.bind(new Object[]{this.lockName, clientId}));
            Row currentLock = resultSet.one();
            if (currentLock.getBool("[applied]") || clientId.equals(currentLock.getString("client"))) {
                return true;
            }
            log.info("Lock currently held by {}", (Object)currentLock);
            return false;
        }
        catch (WriteTimeoutException wte) {
            log.warn("Query to acquire lock for {} failed to execute: {}", (Object)clientId, (Object)wte.getMessage());
            return false;
        }
        catch (DriverException de) {
            throw new CannotAcquireLockException(String.format("Query to acquire lock %s for client %s failed to execute", this.lockName, clientId), de);
        }
    }

    @Override
    public boolean release(String clientId) throws CannotReleaseLockException {
        try {
            boolean noLockExists;
            ResultSet resultSet = this.session.execute((Statement)this.deleteLockQuery.bind(new Object[]{this.lockName, clientId}));
            Row result = resultSet.one();
            boolean bl = noLockExists = !result.getColumnDefinitions().contains("client");
            if (result.getBool("[applied]") || noLockExists) {
                log.info("Lock released for {} by client {} at: {}", new Object[]{this.lockName, clientId, System.currentTimeMillis()});
                return true;
            }
            String clientReleasingLock = result.getString("client");
            if (!clientReleasingLock.equals(clientId)) {
                if (this.isRetryAfterWriteTimeout) {
                    log.info("Released lock for client {} in retry attempt after WriteTimeoutException", (Object)clientReleasingLock);
                    return true;
                }
                throw new CannotReleaseLockException(String.format("Lock %s attempted to be released by a non lock holder (%s). Current lock holder: %s", this.lockName, clientId, clientReleasingLock));
            }
            log.error("Delete lock query did not get applied but client is still {}. This should never happen.", (Object)clientId);
            return false;
        }
        catch (WriteTimeoutException e) {
            this.isRetryAfterWriteTimeout = true;
            return false;
        }
        catch (DriverException e) {
            log.error("Query to release lock failed to execute for {} by client {}", new Object[]{this.lockName, clientId, e});
            throw new CannotReleaseLockException("Query failed to execute", e);
        }
    }
}

