/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.player;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.graphics.Rect;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import tv.danmaku.ijk.media.player.AbstractMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkLibLoader;
import tv.danmaku.ijk.media.player.IjkMediaCodecInfo;
import tv.danmaku.ijk.media.player.IjkMediaMeta;
import tv.danmaku.ijk.media.player.IjkTimedText;
import tv.danmaku.ijk.media.player.MediaInfo;
import tv.danmaku.ijk.media.player.annotations.AccessedByNative;
import tv.danmaku.ijk.media.player.annotations.CalledByNative;
import tv.danmaku.ijk.media.player.misc.IMediaDataSource;
import tv.danmaku.ijk.media.player.misc.IjkTrackInfo;
import tv.danmaku.ijk.media.player.pragma.DebugLog;

public final class IjkMediaPlayer
extends AbstractMediaPlayer {
    private static final String TAG = IjkMediaPlayer.class.getName();
    private static final int MEDIA_NOP = 0;
    private static final int MEDIA_PREPARED = 1;
    private static final int MEDIA_PLAYBACK_COMPLETE = 2;
    private static final int MEDIA_BUFFERING_UPDATE = 3;
    private static final int MEDIA_SEEK_COMPLETE = 4;
    private static final int MEDIA_SET_VIDEO_SIZE = 5;
    private static final int MEDIA_TIMED_TEXT = 99;
    private static final int MEDIA_ERROR = 100;
    private static final int MEDIA_INFO = 200;
    protected static final int MEDIA_SET_VIDEO_SAR = 10001;
    public static final int IJK_LOG_UNKNOWN = 0;
    public static final int IJK_LOG_DEFAULT = 1;
    public static final int IJK_LOG_VERBOSE = 2;
    public static final int IJK_LOG_DEBUG = 3;
    public static final int IJK_LOG_INFO = 4;
    public static final int IJK_LOG_WARN = 5;
    public static final int IJK_LOG_ERROR = 6;
    public static final int IJK_LOG_FATAL = 7;
    public static final int IJK_LOG_SILENT = 8;
    public static final int OPT_CATEGORY_FORMAT = 1;
    public static final int OPT_CATEGORY_CODEC = 2;
    public static final int OPT_CATEGORY_SWS = 3;
    public static final int OPT_CATEGORY_PLAYER = 4;
    public static final int SDL_FCC_YV12 = 842094169;
    public static final int SDL_FCC_RV16 = 909203026;
    public static final int SDL_FCC_RV32 = 842225234;
    public static final int PROP_FLOAT_VIDEO_DECODE_FRAMES_PER_SECOND = 10001;
    public static final int PROP_FLOAT_VIDEO_OUTPUT_FRAMES_PER_SECOND = 10002;
    public static final int FFP_PROP_FLOAT_PLAYBACK_RATE = 10003;
    public static final int FFP_PROP_INT64_SELECTED_VIDEO_STREAM = 20001;
    public static final int FFP_PROP_INT64_SELECTED_AUDIO_STREAM = 20002;
    public static final int FFP_PROP_INT64_SELECTED_TIMEDTEXT_STREAM = 20011;
    public static final int FFP_PROP_INT64_VIDEO_DECODER = 20003;
    public static final int FFP_PROP_INT64_AUDIO_DECODER = 20004;
    public static final int FFP_PROPV_DECODER_UNKNOWN = 0;
    public static final int FFP_PROPV_DECODER_AVCODEC = 1;
    public static final int FFP_PROPV_DECODER_MEDIACODEC = 2;
    public static final int FFP_PROPV_DECODER_VIDEOTOOLBOX = 3;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_DURATION = 20005;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_DURATION = 20006;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_BYTES = 20007;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_BYTES = 20008;
    public static final int FFP_PROP_INT64_VIDEO_CACHED_PACKETS = 20009;
    public static final int FFP_PROP_INT64_AUDIO_CACHED_PACKETS = 20010;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_BACKWARDS = 20201;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_FORWARDS = 20202;
    public static final int FFP_PROP_INT64_ASYNC_STATISTIC_BUF_CAPACITY = 20203;
    public static final int FFP_PROP_INT64_BIT_RATE = 20100;
    public static final int FFP_PROP_INT64_TCP_SPEED = 20200;
    public static final int FFP_PROP_INT64_LATEST_SEEK_LOAD_DURATION = 20300;
    @AccessedByNative
    private long mNativeMediaPlayer;
    @AccessedByNative
    private long mNativeMediaDataSource;
    @AccessedByNative
    private int mNativeSurfaceTexture;
    @AccessedByNative
    private int mListenerContext;
    private SurfaceHolder mSurfaceHolder;
    private EventHandler mEventHandler;
    private PowerManager.WakeLock mWakeLock = null;
    private boolean mScreenOnWhilePlaying;
    private boolean mStayAwake;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mVideoSarNum;
    private int mVideoSarDen;
    private String mDataSource;
    private static final IjkLibLoader sLocalLibLoader = new IjkLibLoader(){

        @Override
        public void loadLibrary(String libName) throws UnsatisfiedLinkError, SecurityException {
            System.loadLibrary(libName);
        }
    };
    private static volatile boolean mIsLibLoaded = false;
    private static volatile boolean mIsNativeInitialized = false;
    private OnControlMessageListener mOnControlMessageListener;
    private OnNativeInvokeListener mOnNativeInvokeListener;
    private OnMediaCodecSelectListener mOnMediaCodecSelectListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadLibrariesOnce(IjkLibLoader libLoader) {
        Class<IjkMediaPlayer> clazz = IjkMediaPlayer.class;
        synchronized (IjkMediaPlayer.class) {
            if (!mIsLibLoaded) {
                if (libLoader == null) {
                    libLoader = sLocalLibLoader;
                }
                libLoader.loadLibrary("ijkffmpeg");
                libLoader.loadLibrary("ijksdl");
                libLoader.loadLibrary("ijkplayer");
                mIsLibLoaded = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initNativeOnce() {
        Class<IjkMediaPlayer> clazz = IjkMediaPlayer.class;
        synchronized (IjkMediaPlayer.class) {
            if (!mIsNativeInitialized) {
                IjkMediaPlayer.native_init();
                mIsNativeInitialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public IjkMediaPlayer() {
        this(sLocalLibLoader);
    }

    public IjkMediaPlayer(IjkLibLoader libLoader) {
        this.initPlayer(libLoader);
    }

    private void initPlayer(IjkLibLoader libLoader) {
        IjkMediaPlayer.loadLibrariesOnce(libLoader);
        IjkMediaPlayer.initNativeOnce();
        Looper looper = Looper.myLooper();
        this.mEventHandler = looper != null ? new EventHandler(this, looper) : ((looper = Looper.getMainLooper()) != null ? new EventHandler(this, looper) : null);
        this.native_setup(new WeakReference<IjkMediaPlayer>(this));
    }

    private native void _setVideoSurface(Surface var1);

    @Override
    public void setDisplay(SurfaceHolder sh) {
        this.mSurfaceHolder = sh;
        Surface surface = sh != null ? sh.getSurface() : null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setSurface(Surface surface) {
        if (this.mScreenOnWhilePlaying && surface != null) {
            DebugLog.w(TAG, "setScreenOnWhilePlaying(true) is ineffective for Surface");
        }
        this.mSurfaceHolder = null;
        this._setVideoSurface(surface);
        this.updateSurfaceScreenOn();
    }

    @Override
    public void setDataSource(Context context, Uri uri) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.setDataSource(context, uri, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=14)
    public void setDataSource(Context context, Uri uri, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        String scheme = uri.getScheme();
        if ("file".equals(scheme)) {
            this.setDataSource(uri.getPath());
            return;
        }
        if ("content".equals(scheme) && "settings".equals(uri.getAuthority()) && (uri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)RingtoneManager.getDefaultType((Uri)uri))) == null) {
            throw new FileNotFoundException("Failed to resolve default ringtone");
        }
        try (AssetFileDescriptor fd = null;){
            ContentResolver resolver = context.getContentResolver();
            fd = resolver.openAssetFileDescriptor(uri, "r");
            if (fd == null) {
                return;
            }
            if (fd.getDeclaredLength() < 0L) {
                this.setDataSource(fd.getFileDescriptor());
            } else {
                this.setDataSource(fd.getFileDescriptor(), fd.getStartOffset(), fd.getDeclaredLength());
            }
            return;
        }
        Log.d((String)TAG, (String)"Couldn't open file on client side, trying server side");
        this.setDataSource(uri.toString(), headers);
    }

    @Override
    public void setDataSource(String path) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        this.mDataSource = path;
        this._setDataSource(path, null, null);
    }

    public void setDataSource(String path, Map<String, String> headers) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException {
        if (headers != null && !headers.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                sb.append(entry.getKey());
                sb.append(":");
                String value = entry.getValue();
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    sb.append(entry.getValue());
                }
                sb.append("\r\n");
                this.setOption(1, "headers", sb.toString());
                this.setOption(1, "protocol_whitelist", "async,cache,crypto,file,http,https,ijkhttphook,ijkinject,ijklivehook,ijklongurl,ijksegment,ijktcphook,pipe,rtp,tcp,tls,udp,ijkurlhook,data");
            }
        }
        this.setDataSource(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=13)
    public void setDataSource(FileDescriptor fd) throws IOException, IllegalArgumentException, IllegalStateException {
        if (Build.VERSION.SDK_INT < 12) {
            int native_fd = -1;
            try {
                Field f = fd.getClass().getDeclaredField("descriptor");
                f.setAccessible(true);
                native_fd = f.getInt(fd);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            this._setDataSourceFd(native_fd);
        } else {
            try (ParcelFileDescriptor pfd = ParcelFileDescriptor.dup((FileDescriptor)fd);){
                this._setDataSourceFd(pfd.getFd());
            }
        }
    }

    private void setDataSource(FileDescriptor fd, long offset, long length) throws IOException, IllegalArgumentException, IllegalStateException {
        this.setDataSource(fd);
    }

    @Override
    public void setDataSource(IMediaDataSource mediaDataSource) throws IllegalArgumentException, SecurityException, IllegalStateException {
        this._setDataSource(mediaDataSource);
    }

    private native void _setDataSource(String var1, String[] var2, String[] var3) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSourceFd(int var1) throws IOException, IllegalArgumentException, SecurityException, IllegalStateException;

    private native void _setDataSource(IMediaDataSource var1) throws IllegalArgumentException, SecurityException, IllegalStateException;

    @Override
    public String getDataSource() {
        return this.mDataSource;
    }

    @Override
    public void prepareAsync() throws IllegalStateException {
        this._prepareAsync();
    }

    public native void _prepareAsync() throws IllegalStateException;

    @Override
    public void start() throws IllegalStateException {
        this.stayAwake(true);
        this._start();
    }

    private native void _start() throws IllegalStateException;

    @Override
    public void stop() throws IllegalStateException {
        this.stayAwake(false);
        this._stop();
    }

    private native void _stop() throws IllegalStateException;

    @Override
    public void pause() throws IllegalStateException {
        this.stayAwake(false);
        this._pause();
    }

    private native void _pause() throws IllegalStateException;

    @Override
    @SuppressLint(value={"Wakelock"})
    public void setWakeMode(Context context, int mode) {
        boolean washeld = false;
        if (this.mWakeLock != null) {
            if (this.mWakeLock.isHeld()) {
                washeld = true;
                this.mWakeLock.release();
            }
            this.mWakeLock = null;
        }
        PowerManager pm = (PowerManager)context.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(mode | 0x20000000, IjkMediaPlayer.class.getName());
        this.mWakeLock.setReferenceCounted(false);
        if (washeld) {
            this.mWakeLock.acquire();
        }
    }

    @Override
    public void setScreenOnWhilePlaying(boolean screenOn) {
        if (this.mScreenOnWhilePlaying != screenOn) {
            if (screenOn && this.mSurfaceHolder == null) {
                DebugLog.w(TAG, "setScreenOnWhilePlaying(true) is ineffective without a SurfaceHolder");
            }
            this.mScreenOnWhilePlaying = screenOn;
            this.updateSurfaceScreenOn();
        }
    }

    @SuppressLint(value={"Wakelock"})
    private void stayAwake(boolean awake) {
        if (this.mWakeLock != null) {
            if (awake && !this.mWakeLock.isHeld()) {
                this.mWakeLock.acquire();
            } else if (!awake && this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
        }
        this.mStayAwake = awake;
        this.updateSurfaceScreenOn();
    }

    private void updateSurfaceScreenOn() {
        if (this.mSurfaceHolder != null) {
            this.mSurfaceHolder.setKeepScreenOn(this.mScreenOnWhilePlaying && this.mStayAwake);
        }
    }

    public IjkTrackInfo[] getTrackInfo() {
        Bundle bundle = this.getMediaMeta();
        if (bundle == null) {
            return null;
        }
        IjkMediaMeta mediaMeta = IjkMediaMeta.parse(bundle);
        if (mediaMeta == null || mediaMeta.mStreams == null) {
            return null;
        }
        ArrayList<IjkTrackInfo> trackInfos = new ArrayList<IjkTrackInfo>();
        for (IjkMediaMeta.IjkStreamMeta streamMeta : mediaMeta.mStreams) {
            IjkTrackInfo trackInfo = new IjkTrackInfo(streamMeta);
            if (streamMeta.mType.equalsIgnoreCase("video")) {
                trackInfo.setTrackType(1);
            } else if (streamMeta.mType.equalsIgnoreCase("audio")) {
                trackInfo.setTrackType(2);
            } else if (streamMeta.mType.equalsIgnoreCase("timedtext")) {
                trackInfo.setTrackType(3);
            }
            trackInfos.add(trackInfo);
        }
        return trackInfos.toArray(new IjkTrackInfo[trackInfos.size()]);
    }

    public int getSelectedTrack(int trackType) {
        switch (trackType) {
            case 1: {
                return (int)this._getPropertyLong(20001, -1L);
            }
            case 2: {
                return (int)this._getPropertyLong(20002, -1L);
            }
            case 3: {
                return (int)this._getPropertyLong(20011, -1L);
            }
        }
        return -1;
    }

    public void selectTrack(int track) {
        this._setStreamSelected(track, true);
    }

    public void deselectTrack(int track) {
        this._setStreamSelected(track, false);
    }

    private native void _setStreamSelected(int var1, boolean var2);

    @Override
    public int getVideoWidth() {
        return this.mVideoWidth;
    }

    @Override
    public int getVideoHeight() {
        return this.mVideoHeight;
    }

    @Override
    public int getVideoSarNum() {
        return this.mVideoSarNum;
    }

    @Override
    public int getVideoSarDen() {
        return this.mVideoSarDen;
    }

    @Override
    public native boolean isPlaying();

    @Override
    public native void seekTo(long var1) throws IllegalStateException;

    @Override
    public native long getCurrentPosition();

    @Override
    public native long getDuration();

    @Override
    public void release() {
        this.stayAwake(false);
        this.updateSurfaceScreenOn();
        this.resetListeners();
        this._release();
    }

    private native void _release();

    @Override
    public void reset() {
        this.stayAwake(false);
        this._reset();
        this.mEventHandler.removeCallbacksAndMessages(null);
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
    }

    private native void _reset();

    @Override
    public void setLooping(boolean looping) {
        int loopCount = looping ? 0 : 1;
        this.setOption(4, "loop", loopCount);
        this._setLoopCount(loopCount);
    }

    private native void _setLoopCount(int var1);

    @Override
    public boolean isLooping() {
        int loopCount = this._getLoopCount();
        return loopCount != 1;
    }

    private native int _getLoopCount();

    public void setSpeed(float speed) {
        this._setPropertyFloat(10003, speed);
    }

    public float getSpeed(float speed) {
        return this._getPropertyFloat(10003, 0.0f);
    }

    public int getVideoDecoder() {
        return (int)this._getPropertyLong(20003, 0L);
    }

    public float getVideoOutputFramesPerSecond() {
        return this._getPropertyFloat(10002, 0.0f);
    }

    public float getVideoDecodeFramesPerSecond() {
        return this._getPropertyFloat(10001, 0.0f);
    }

    public long getVideoCachedDuration() {
        return this._getPropertyLong(20005, 0L);
    }

    public long getAudioCachedDuration() {
        return this._getPropertyLong(20006, 0L);
    }

    public long getVideoCachedBytes() {
        return this._getPropertyLong(20007, 0L);
    }

    public long getAudioCachedBytes() {
        return this._getPropertyLong(20008, 0L);
    }

    public long getVideoCachedPackets() {
        return this._getPropertyLong(20009, 0L);
    }

    public long getAudioCachedPackets() {
        return this._getPropertyLong(20010, 0L);
    }

    public long getAsyncStatisticBufBackwards() {
        return this._getPropertyLong(20201, 0L);
    }

    public long getAsyncStatisticBufForwards() {
        return this._getPropertyLong(20202, 0L);
    }

    public long getAsyncStatisticBufCapacity() {
        return this._getPropertyLong(20203, 0L);
    }

    public long getBitRate() {
        return this._getPropertyLong(20100, 0L);
    }

    public long getTcpSpeed() {
        return this._getPropertyLong(20200, 0L);
    }

    public long getSeekLoadDuration() {
        return this._getPropertyLong(20300, 0L);
    }

    private native float _getPropertyFloat(int var1, float var2);

    private native void _setPropertyFloat(int var1, float var2);

    private native long _getPropertyLong(int var1, long var2);

    private native void _setPropertyLong(int var1, long var2);

    @Override
    public native void setVolume(float var1, float var2);

    @Override
    public native int getAudioSessionId();

    @Override
    public MediaInfo getMediaInfo() {
        String audioCodecInfo;
        MediaInfo mediaInfo = new MediaInfo();
        mediaInfo.mMediaPlayerName = "ijkplayer";
        String videoCodecInfo = this._getVideoCodecInfo();
        if (!TextUtils.isEmpty((CharSequence)videoCodecInfo)) {
            String[] nodes = videoCodecInfo.split(",");
            if (nodes.length >= 2) {
                mediaInfo.mVideoDecoder = nodes[0];
                mediaInfo.mVideoDecoderImpl = nodes[1];
            } else if (nodes.length >= 1) {
                mediaInfo.mVideoDecoder = nodes[0];
                mediaInfo.mVideoDecoderImpl = "";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(audioCodecInfo = this._getAudioCodecInfo()))) {
            String[] nodes = audioCodecInfo.split(",");
            if (nodes.length >= 2) {
                mediaInfo.mAudioDecoder = nodes[0];
                mediaInfo.mAudioDecoderImpl = nodes[1];
            } else if (nodes.length >= 1) {
                mediaInfo.mAudioDecoder = nodes[0];
                mediaInfo.mAudioDecoderImpl = "";
            }
        }
        try {
            mediaInfo.mMeta = IjkMediaMeta.parse(this._getMediaMeta());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return mediaInfo;
    }

    @Override
    public void setLogEnabled(boolean enable) {
    }

    @Override
    public boolean isPlayable() {
        return true;
    }

    private native String _getVideoCodecInfo();

    private native String _getAudioCodecInfo();

    public void setOption(int category, String name, String value) {
        this._setOption(category, name, value);
    }

    public void setOption(int category, String name, long value) {
        this._setOption(category, name, value);
    }

    private native void _setOption(int var1, String var2, String var3);

    private native void _setOption(int var1, String var2, long var3);

    public Bundle getMediaMeta() {
        return this._getMediaMeta();
    }

    private native Bundle _getMediaMeta();

    public static String getColorFormatName(int mediaCodecColorFormat) {
        return IjkMediaPlayer._getColorFormatName(mediaCodecColorFormat);
    }

    private static native String _getColorFormatName(int var0);

    @Override
    public void setAudioStreamType(int streamtype) {
    }

    @Override
    public void setKeepInBackground(boolean keepInBackground) {
    }

    private static native void native_init();

    private native void native_setup(Object var1);

    private native void native_finalize();

    private native void native_message_loop(Object var1);

    protected void finalize() throws Throwable {
        super.finalize();
        this.native_finalize();
    }

    @CalledByNative
    private static void postEventFromNative(Object weakThiz, int what, int arg1, int arg2, Object obj) {
        if (weakThiz == null) {
            return;
        }
        IjkMediaPlayer mp = (IjkMediaPlayer)((WeakReference)weakThiz).get();
        if (mp == null) {
            return;
        }
        if (what == 200 && arg1 == 2) {
            mp.start();
        }
        if (mp.mEventHandler != null) {
            Message m = mp.mEventHandler.obtainMessage(what, arg1, arg2, obj);
            mp.mEventHandler.sendMessage(m);
        }
    }

    public void setOnControlMessageListener(OnControlMessageListener listener) {
        this.mOnControlMessageListener = listener;
    }

    public void setOnNativeInvokeListener(OnNativeInvokeListener listener) {
        this.mOnNativeInvokeListener = listener;
    }

    @CalledByNative
    private static boolean onNativeInvoke(Object weakThiz, int what, Bundle args) {
        DebugLog.ifmt(TAG, "onNativeInvoke %d", what);
        if (weakThiz == null || !(weakThiz instanceof WeakReference)) {
            throw new IllegalStateException("<null weakThiz>.onNativeInvoke()");
        }
        WeakReference weakPlayer = (WeakReference)weakThiz;
        IjkMediaPlayer player = (IjkMediaPlayer)weakPlayer.get();
        if (player == null) {
            throw new IllegalStateException("<null weakPlayer>.onNativeInvoke()");
        }
        OnNativeInvokeListener listener = player.mOnNativeInvokeListener;
        if (listener != null && listener.onNativeInvoke(what, args)) {
            return true;
        }
        switch (what) {
            case 131079: {
                OnControlMessageListener onControlMessageListener = player.mOnControlMessageListener;
                if (onControlMessageListener == null) {
                    return false;
                }
                int segmentIndex = args.getInt("segment_index", -1);
                if (segmentIndex < 0) {
                    throw new InvalidParameterException("onNativeInvoke(invalid segment index)");
                }
                String newUrl = onControlMessageListener.onControlResolveSegmentUrl(segmentIndex);
                if (newUrl == null) {
                    throw new RuntimeException(new IOException("onNativeInvoke() = <NULL newUrl>"));
                }
                args.putString("url", newUrl);
                return true;
            }
        }
        return false;
    }

    public void setOnMediaCodecSelectListener(OnMediaCodecSelectListener listener) {
        this.mOnMediaCodecSelectListener = listener;
    }

    @Override
    public void resetListeners() {
        super.resetListeners();
        this.mOnMediaCodecSelectListener = null;
    }

    @CalledByNative
    private static String onSelectCodec(Object weakThiz, String mimeType, int profile, int level) {
        if (weakThiz == null || !(weakThiz instanceof WeakReference)) {
            return null;
        }
        WeakReference weakPlayer = (WeakReference)weakThiz;
        IjkMediaPlayer player = (IjkMediaPlayer)weakPlayer.get();
        if (player == null) {
            return null;
        }
        OnMediaCodecSelectListener listener = player.mOnMediaCodecSelectListener;
        if (listener == null) {
            listener = DefaultMediaCodecSelector.sInstance;
        }
        return listener.onMediaCodecSelect(player, mimeType, profile, level);
    }

    public static native void native_profileBegin(String var0);

    public static native void native_profileEnd();

    public static native void native_setLogLevel(int var0);

    public static class DefaultMediaCodecSelector
    implements OnMediaCodecSelectListener {
        public static final DefaultMediaCodecSelector sInstance = new DefaultMediaCodecSelector();

        @Override
        @TargetApi(value=16)
        public String onMediaCodecSelect(IMediaPlayer mp, String mimeType, int profile, int level) {
            if (Build.VERSION.SDK_INT < 16) {
                return null;
            }
            if (TextUtils.isEmpty((CharSequence)mimeType)) {
                return null;
            }
            Log.i((String)TAG, (String)String.format(Locale.US, "onSelectCodec: mime=%s, profile=%d, level=%d", mimeType, profile, level));
            ArrayList<IjkMediaCodecInfo> candidateCodecList = new ArrayList<IjkMediaCodecInfo>();
            int numCodecs = MediaCodecList.getCodecCount();
            for (int i = 0; i < numCodecs; ++i) {
                String[] types;
                MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
                Log.d((String)TAG, (String)String.format(Locale.US, "  found codec: %s", codecInfo.getName()));
                if (codecInfo.isEncoder() || (types = codecInfo.getSupportedTypes()) == null) continue;
                for (String type : types) {
                    IjkMediaCodecInfo candidate;
                    if (TextUtils.isEmpty((CharSequence)type)) continue;
                    Log.d((String)TAG, (String)String.format(Locale.US, "    mime: %s", type));
                    if (!type.equalsIgnoreCase(mimeType) || (candidate = IjkMediaCodecInfo.setupCandidate(codecInfo, mimeType)) == null) continue;
                    candidateCodecList.add(candidate);
                    Log.i((String)TAG, (String)String.format(Locale.US, "candidate codec: %s rank=%d", codecInfo.getName(), candidate.mRank));
                    candidate.dumpProfileLevels(mimeType);
                }
            }
            if (candidateCodecList.isEmpty()) {
                return null;
            }
            IjkMediaCodecInfo bestCodec = (IjkMediaCodecInfo)candidateCodecList.get(0);
            for (IjkMediaCodecInfo codec : candidateCodecList) {
                if (codec.mRank <= bestCodec.mRank) continue;
                bestCodec = codec;
            }
            if (bestCodec.mRank < 600) {
                Log.w((String)TAG, (String)String.format(Locale.US, "unaccetable codec: %s", bestCodec.mCodecInfo.getName()));
                return null;
            }
            Log.i((String)TAG, (String)String.format(Locale.US, "selected codec: %s rank=%d", bestCodec.mCodecInfo.getName(), bestCodec.mRank));
            return bestCodec.mCodecInfo.getName();
        }
    }

    public static interface OnMediaCodecSelectListener {
        public String onMediaCodecSelect(IMediaPlayer var1, String var2, int var3, int var4);
    }

    public static interface OnNativeInvokeListener {
        public static final int CTRL_WILL_TCP_OPEN = 131073;
        public static final int CTRL_DID_TCP_OPEN = 131074;
        public static final int CTRL_WILL_HTTP_OPEN = 131075;
        public static final int CTRL_WILL_LIVE_OPEN = 131077;
        public static final int CTRL_WILL_CONCAT_RESOLVE_SEGMENT = 131079;
        public static final int EVENT_WILL_HTTP_OPEN = 1;
        public static final int EVENT_DID_HTTP_OPEN = 2;
        public static final int EVENT_WILL_HTTP_SEEK = 3;
        public static final int EVENT_DID_HTTP_SEEK = 4;
        public static final String ARG_URL = "url";
        public static final String ARG_SEGMENT_INDEX = "segment_index";
        public static final String ARG_RETRY_COUNTER = "retry_counter";
        public static final String ARG_ERROR = "error";
        public static final String ARG_FAMILIY = "family";
        public static final String ARG_IP = "ip";
        public static final String ARG_PORT = "port";
        public static final String ARG_FD = "fd";
        public static final String ARG_OFFSET = "offset";
        public static final String ARG_HTTP_CODE = "http_code";

        public boolean onNativeInvoke(int var1, Bundle var2);
    }

    public static interface OnControlMessageListener {
        public String onControlResolveSegmentUrl(int var1);
    }

    private static class EventHandler
    extends Handler {
        private final WeakReference<IjkMediaPlayer> mWeakPlayer;

        public EventHandler(IjkMediaPlayer mp, Looper looper) {
            super(looper);
            this.mWeakPlayer = new WeakReference<IjkMediaPlayer>(mp);
        }

        public void handleMessage(Message msg) {
            IjkMediaPlayer player = (IjkMediaPlayer)this.mWeakPlayer.get();
            if (player == null || player.mNativeMediaPlayer == 0L) {
                DebugLog.w(TAG, "IjkMediaPlayer went away with unhandled events");
                return;
            }
            switch (msg.what) {
                case 1: {
                    player.notifyOnPrepared();
                    return;
                }
                case 2: {
                    player.stayAwake(false);
                    player.notifyOnCompletion();
                    return;
                }
                case 3: {
                    long bufferPosition = msg.arg1;
                    if (bufferPosition < 0L) {
                        bufferPosition = 0L;
                    }
                    long percent = 0L;
                    long duration = player.getDuration();
                    if (duration > 0L) {
                        percent = bufferPosition * 100L / duration;
                    }
                    if (percent >= 100L) {
                        percent = 100L;
                    }
                    player.notifyOnBufferingUpdate((int)percent);
                    return;
                }
                case 4: {
                    player.notifyOnSeekComplete();
                    return;
                }
                case 5: {
                    player.mVideoWidth = msg.arg1;
                    player.mVideoHeight = msg.arg2;
                    player.notifyOnVideoSizeChanged(player.mVideoWidth, player.mVideoHeight, player.mVideoSarNum, player.mVideoSarDen);
                    return;
                }
                case 100: {
                    DebugLog.e(TAG, "Error (" + msg.arg1 + "," + msg.arg2 + ")");
                    if (!player.notifyOnError(msg.arg1, msg.arg2)) {
                        player.notifyOnCompletion();
                    }
                    player.stayAwake(false);
                    return;
                }
                case 200: {
                    switch (msg.arg1) {
                        case 3: {
                            DebugLog.i(TAG, "Info: MEDIA_INFO_VIDEO_RENDERING_START\n");
                        }
                    }
                    player.notifyOnInfo(msg.arg1, msg.arg2);
                    return;
                }
                case 99: {
                    if (msg.obj == null) {
                        player.notifyOnTimedText(null);
                    } else {
                        IjkTimedText text = new IjkTimedText(new Rect(0, 0, 1, 1), (String)msg.obj);
                        player.notifyOnTimedText(text);
                    }
                    return;
                }
                case 0: {
                    break;
                }
                case 10001: {
                    player.mVideoSarNum = msg.arg1;
                    player.mVideoSarDen = msg.arg2;
                    player.notifyOnVideoSizeChanged(player.mVideoWidth, player.mVideoHeight, player.mVideoSarNum, player.mVideoSarDen);
                    break;
                }
                default: {
                    DebugLog.e(TAG, "Unknown message type " + msg.what);
                }
            }
        }
    }
}

