/*
 * Decompiled with CFR 0.152.
 */
package tv.danmaku.ijk.media.player;

import android.os.Bundle;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Locale;

public class IjkMediaMeta {
    public static final String IJKM_KEY_FORMAT = "format";
    public static final String IJKM_KEY_DURATION_US = "duration_us";
    public static final String IJKM_KEY_START_US = "start_us";
    public static final String IJKM_KEY_BITRATE = "bitrate";
    public static final String IJKM_KEY_VIDEO_STREAM = "video";
    public static final String IJKM_KEY_AUDIO_STREAM = "audio";
    public static final String IJKM_KEY_TYPE = "type";
    public static final String IJKM_VAL_TYPE__VIDEO = "video";
    public static final String IJKM_VAL_TYPE__AUDIO = "audio";
    public static final String IJKM_VAL_TYPE__UNKNOWN = "unknown";
    public static final String IJKM_KEY_LANGUAGE = "language";
    public static final String IJKM_KEY_CODEC_NAME = "codec_name";
    public static final String IJKM_KEY_CODEC_PROFILE = "codec_profile";
    public static final String IJKM_KEY_CODEC_LEVEL = "codec_level";
    public static final String IJKM_KEY_CODEC_LONG_NAME = "codec_long_name";
    public static final String IJKM_KEY_CODEC_PIXEL_FORMAT = "codec_pixel_format";
    public static final String IJKM_KEY_WIDTH = "width";
    public static final String IJKM_KEY_HEIGHT = "height";
    public static final String IJKM_KEY_FPS_NUM = "fps_num";
    public static final String IJKM_KEY_FPS_DEN = "fps_den";
    public static final String IJKM_KEY_TBR_NUM = "tbr_num";
    public static final String IJKM_KEY_TBR_DEN = "tbr_den";
    public static final String IJKM_KEY_SAR_NUM = "sar_num";
    public static final String IJKM_KEY_SAR_DEN = "sar_den";
    public static final String IJKM_KEY_SAMPLE_RATE = "sample_rate";
    public static final String IJKM_KEY_CHANNEL_LAYOUT = "channel_layout";
    public static final String IJKM_KEY_STREAMS = "streams";
    public static final long AV_CH_FRONT_LEFT = 1L;
    public static final long AV_CH_FRONT_RIGHT = 2L;
    public static final long AV_CH_FRONT_CENTER = 4L;
    public static final long AV_CH_LOW_FREQUENCY = 8L;
    public static final long AV_CH_BACK_LEFT = 16L;
    public static final long AV_CH_BACK_RIGHT = 32L;
    public static final long AV_CH_FRONT_LEFT_OF_CENTER = 64L;
    public static final long AV_CH_FRONT_RIGHT_OF_CENTER = 128L;
    public static final long AV_CH_BACK_CENTER = 256L;
    public static final long AV_CH_SIDE_LEFT = 512L;
    public static final long AV_CH_SIDE_RIGHT = 1024L;
    public static final long AV_CH_TOP_CENTER = 2048L;
    public static final long AV_CH_TOP_FRONT_LEFT = 4096L;
    public static final long AV_CH_TOP_FRONT_CENTER = 8192L;
    public static final long AV_CH_TOP_FRONT_RIGHT = 16384L;
    public static final long AV_CH_TOP_BACK_LEFT = 32768L;
    public static final long AV_CH_TOP_BACK_CENTER = 65536L;
    public static final long AV_CH_TOP_BACK_RIGHT = 131072L;
    public static final long AV_CH_STEREO_LEFT = 0x20000000L;
    public static final long AV_CH_STEREO_RIGHT = 0x40000000L;
    public static final long AV_CH_WIDE_LEFT = 0x80000000L;
    public static final long AV_CH_WIDE_RIGHT = 0x100000000L;
    public static final long AV_CH_SURROUND_DIRECT_LEFT = 0x200000000L;
    public static final long AV_CH_SURROUND_DIRECT_RIGHT = 0x400000000L;
    public static final long AV_CH_LOW_FREQUENCY_2 = 0x800000000L;
    public static final long AV_CH_LAYOUT_MONO = 4L;
    public static final long AV_CH_LAYOUT_STEREO = 3L;
    public static final long AV_CH_LAYOUT_2POINT1 = 11L;
    public static final long AV_CH_LAYOUT_2_1 = 259L;
    public static final long AV_CH_LAYOUT_SURROUND = 7L;
    public static final long AV_CH_LAYOUT_3POINT1 = 15L;
    public static final long AV_CH_LAYOUT_4POINT0 = 263L;
    public static final long AV_CH_LAYOUT_4POINT1 = 271L;
    public static final long AV_CH_LAYOUT_2_2 = 1539L;
    public static final long AV_CH_LAYOUT_QUAD = 51L;
    public static final long AV_CH_LAYOUT_5POINT0 = 1543L;
    public static final long AV_CH_LAYOUT_5POINT1 = 1551L;
    public static final long AV_CH_LAYOUT_5POINT0_BACK = 55L;
    public static final long AV_CH_LAYOUT_5POINT1_BACK = 63L;
    public static final long AV_CH_LAYOUT_6POINT0 = 1799L;
    public static final long AV_CH_LAYOUT_6POINT0_FRONT = 1731L;
    public static final long AV_CH_LAYOUT_HEXAGONAL = 311L;
    public static final long AV_CH_LAYOUT_6POINT1 = 1807L;
    public static final long AV_CH_LAYOUT_6POINT1_BACK = 319L;
    public static final long AV_CH_LAYOUT_6POINT1_FRONT = 1739L;
    public static final long AV_CH_LAYOUT_7POINT0 = 1591L;
    public static final long AV_CH_LAYOUT_7POINT0_FRONT = 1735L;
    public static final long AV_CH_LAYOUT_7POINT1 = 1599L;
    public static final long AV_CH_LAYOUT_7POINT1_WIDE = 1743L;
    public static final long AV_CH_LAYOUT_7POINT1_WIDE_BACK = 255L;
    public static final long AV_CH_LAYOUT_OCTAGONAL = 1847L;
    public static final long AV_CH_LAYOUT_STEREO_DOWNMIX = 0x60000000L;
    public Bundle mMediaMeta;
    public String mFormat;
    public long mDurationUS;
    public long mStartUS;
    public long mBitrate;
    public final ArrayList<IjkStreamMeta> mStreams = new ArrayList();
    public IjkStreamMeta mVideoStream;
    public IjkStreamMeta mAudioStream;

    public String getString(String key) {
        return this.mMediaMeta.getString(key);
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        if (TextUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public ArrayList<Bundle> getParcelableArrayList(String key) {
        return this.mMediaMeta.getParcelableArrayList(key);
    }

    public String getDurationInline() {
        long duration = this.mDurationUS + 5000L;
        long secs = duration / 1000000L;
        long mins = secs / 60L;
        long hours = mins / 60L;
        return String.format(Locale.US, "%02d:%02d:%02d", hours, mins %= 60L, secs %= 60L);
    }

    public static IjkMediaMeta parse(Bundle mediaMeta) {
        if (mediaMeta == null) {
            return null;
        }
        IjkMediaMeta meta = new IjkMediaMeta();
        meta.mMediaMeta = mediaMeta;
        meta.mFormat = meta.getString(IJKM_KEY_FORMAT);
        meta.mDurationUS = meta.getLong(IJKM_KEY_DURATION_US);
        meta.mStartUS = meta.getLong(IJKM_KEY_START_US);
        meta.mBitrate = meta.getLong(IJKM_KEY_BITRATE);
        int videoStreamIndex = meta.getInt("video", -1);
        int audioStreamIndex = meta.getInt("audio", -1);
        ArrayList<Bundle> streams = meta.getParcelableArrayList(IJKM_KEY_STREAMS);
        if (streams == null) {
            return meta;
        }
        int index = -1;
        for (Bundle streamBundle : streams) {
            ++index;
            if (streamBundle == null) continue;
            IjkStreamMeta streamMeta = new IjkStreamMeta(index);
            streamMeta.mMeta = streamBundle;
            streamMeta.mType = streamMeta.getString(IJKM_KEY_TYPE);
            streamMeta.mLanguage = streamMeta.getString(IJKM_KEY_LANGUAGE);
            if (TextUtils.isEmpty((CharSequence)streamMeta.mType)) continue;
            streamMeta.mCodecName = streamMeta.getString(IJKM_KEY_CODEC_NAME);
            streamMeta.mCodecProfile = streamMeta.getString(IJKM_KEY_CODEC_PROFILE);
            streamMeta.mCodecLongName = streamMeta.getString(IJKM_KEY_CODEC_LONG_NAME);
            streamMeta.mBitrate = streamMeta.getInt(IJKM_KEY_BITRATE);
            if (streamMeta.mType.equalsIgnoreCase("video")) {
                streamMeta.mWidth = streamMeta.getInt(IJKM_KEY_WIDTH);
                streamMeta.mHeight = streamMeta.getInt(IJKM_KEY_HEIGHT);
                streamMeta.mFpsNum = streamMeta.getInt(IJKM_KEY_FPS_NUM);
                streamMeta.mFpsDen = streamMeta.getInt(IJKM_KEY_FPS_DEN);
                streamMeta.mTbrNum = streamMeta.getInt(IJKM_KEY_TBR_NUM);
                streamMeta.mTbrDen = streamMeta.getInt(IJKM_KEY_TBR_DEN);
                streamMeta.mSarNum = streamMeta.getInt(IJKM_KEY_SAR_NUM);
                streamMeta.mSarDen = streamMeta.getInt(IJKM_KEY_SAR_DEN);
                if (videoStreamIndex == index) {
                    meta.mVideoStream = streamMeta;
                }
            } else if (streamMeta.mType.equalsIgnoreCase("audio")) {
                streamMeta.mSampleRate = streamMeta.getInt(IJKM_KEY_SAMPLE_RATE);
                streamMeta.mChannelLayout = streamMeta.getLong(IJKM_KEY_CHANNEL_LAYOUT);
                if (audioStreamIndex == index) {
                    meta.mAudioStream = streamMeta;
                }
            }
            meta.mStreams.add(streamMeta);
        }
        return meta;
    }

    public static class IjkStreamMeta {
        public Bundle mMeta;
        public final int mIndex;
        public String mType;
        public String mLanguage;
        public String mCodecName;
        public String mCodecProfile;
        public String mCodecLongName;
        public long mBitrate;
        public int mWidth;
        public int mHeight;
        public int mFpsNum;
        public int mFpsDen;
        public int mTbrNum;
        public int mTbrDen;
        public int mSarNum;
        public int mSarDen;
        public int mSampleRate;
        public long mChannelLayout;

        public IjkStreamMeta(int index) {
            this.mIndex = index;
        }

        public String getString(String key) {
            return this.mMeta.getString(key);
        }

        public int getInt(String key) {
            return this.getInt(key, 0);
        }

        public int getInt(String key, int defaultValue) {
            String value = this.getString(key);
            if (TextUtils.isEmpty((CharSequence)value)) {
                return defaultValue;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        public long getLong(String key) {
            return this.getLong(key, 0L);
        }

        public long getLong(String key, long defaultValue) {
            String value = this.getString(key);
            if (TextUtils.isEmpty((CharSequence)value)) {
                return defaultValue;
            }
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        public String getCodecLongNameInline() {
            if (!TextUtils.isEmpty((CharSequence)this.mCodecLongName)) {
                return this.mCodecLongName;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mCodecName)) {
                return this.mCodecName;
            }
            return "N/A";
        }

        public String getCodecShortNameInline() {
            if (!TextUtils.isEmpty((CharSequence)this.mCodecName)) {
                return this.mCodecName;
            }
            return "N/A";
        }

        public String getResolutionInline() {
            if (this.mWidth <= 0 || this.mHeight <= 0) {
                return "N/A";
            }
            if (this.mSarNum <= 0 || this.mSarDen <= 0) {
                return String.format(Locale.US, "%d x %d", this.mWidth, this.mHeight);
            }
            return String.format(Locale.US, "%d x %d [SAR %d:%d]", this.mWidth, this.mHeight, this.mSarNum, this.mSarDen);
        }

        public String getFpsInline() {
            if (this.mFpsNum <= 0 || this.mFpsDen <= 0) {
                return "N/A";
            }
            return String.valueOf((float)this.mFpsNum / (float)this.mFpsDen);
        }

        public String getBitrateInline() {
            if (this.mBitrate <= 0L) {
                return "N/A";
            }
            if (this.mBitrate < 1000L) {
                return String.format(Locale.US, "%d bit/s", this.mBitrate);
            }
            return String.format(Locale.US, "%d kb/s", this.mBitrate / 1000L);
        }

        public String getSampleRateInline() {
            if (this.mSampleRate <= 0) {
                return "N/A";
            }
            return String.format(Locale.US, "%d Hz", this.mSampleRate);
        }

        public String getChannelLayoutInline() {
            if (this.mChannelLayout <= 0L) {
                return "N/A";
            }
            if (this.mChannelLayout == 4L) {
                return "mono";
            }
            if (this.mChannelLayout == 3L) {
                return "stereo";
            }
            return String.format(Locale.US, "%x", this.mChannelLayout);
        }
    }
}

