package top.mdoufei.logkit;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by leon on 2018/5/23.
 */

public class LogManager {

    private static final List<Adaptor> adaptors = new ArrayList<>();

    //with custom tag
    public void d( String tag, String message) {
        log(LogKit.DEBUG,tag,message,null);
    }

    public  void e( String tag, String message) {
        log(LogKit.ERROR,tag,message,null);
    }

    public  void e( String tag, String message,  Throwable throwable) {
        log(LogKit.ERROR,tag,message,throwable);
    }

    public  void i( String tag, String message) {
        log(LogKit.INFO,tag,message,null);
    }

    public  void w( String tag, String message) {
        log(LogKit.WARN,tag,message,null);
    }

    public  void v(String tag,String message) {
        log(LogKit.VERBOSE,tag,message,null);
    }


    // default tag
    public void d(String message) {
        log(LogKit.DEBUG,LogKit.TAG,message,null);
    }

    public  void e(String message) {
        log(LogKit.ERROR,LogKit.TAG,message,null);
    }

    public  void e( String message,  Throwable throwable) {
        log(LogKit.ERROR,LogKit.TAG,message,throwable);
    }

    public  void i(String message) {
        log(LogKit.INFO,LogKit.TAG,message,null);
    }

    public  void w(String message) {
        log(LogKit.WARN,LogKit.TAG,message,null);
    }

    public  void v(String message) {
        log(LogKit.VERBOSE,LogKit.TAG,message,null);
    }

    public void addAdapter(Adaptor adaptor){
        this.adaptors.add(adaptor);
    }

    public synchronized void log(int priority,String tag,
                                 String message, Throwable throwable) {

        if (throwable != null && message != null) {
            message += " : " + Util.getStackTraceString(throwable);
        }

       for (Adaptor adapter : adaptors) {
            if (adapter.isLoggable(priority)) {
                adapter.log(priority,tag,message);
            }
        }
    }

}
