/*
 * Decompiled with CFR 0.152.
 */
package top.guuguo.progress_lib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.os.Handler;
import android.os.Message;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import top.guuguo.progress_lib.R;
import top.guuguo.progress_lib.util.DensityUtil;

public class MyProgressWave
extends View {
    private Paint textPaint;
    private RectF rectF = new RectF();
    private float textSize;
    private float circleWidth;
    private int textColor;
    private boolean enableCenterText;
    private boolean enableWave;
    private float progress = 0.0f;
    private int max;
    private int style;
    private int finishedColor;
    private int unfinishedColor;
    private int circleColor;
    private String prefixText = "";
    private String suffixText = "%";
    private Bitmap mMaskBitmap;
    private boolean changeHeight = true;
    private Bitmap mWaveBitmap;
    private final int STYLE_CIRCLE = 0;
    private final int STYLE_SQUARE = 1;
    private String forceTitle;
    private final int default_finished_color = Color.rgb((int)66, (int)145, (int)241);
    private final int default_unfinished_color = Color.rgb((int)204, (int)204, (int)204);
    private final int default_text_color = -1;
    private final int default_max = 100;
    private final float default_text_size;
    private final boolean default_enable_center_text = false;
    private final float default_circle_width;
    private double periodMultiple = 15.0;
    private Paint paint = new Paint();
    float offset = 0.0f;
    private static final String TAG = "MyProgressWave";
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MyProgressWave.this.invalidate();
                }
            }
            super.handleMessage(msg);
        }
    };

    public String getForceTitle() {
        return this.forceTitle;
    }

    public void setForceTitle(String forceTitle) {
        this.forceTitle = forceTitle;
        this.invalidate();
    }

    public MyProgressWave(Context context) {
        this(context, null);
    }

    public MyProgressWave(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MyProgressWave(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.default_text_size = DensityUtil.dip2px(this.getContext(), 18.0f);
        this.default_circle_width = DensityUtil.dip2px(this.getContext(), 2.0f);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MyProgressWave, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPainters();
        this.StartWave();
    }

    protected void initByAttributes(TypedArray attributes) {
        this.finishedColor = attributes.getColor(R.styleable.MyProgressWave_wave_finished_color, this.default_finished_color);
        this.unfinishedColor = attributes.getColor(R.styleable.MyProgressWave_wave_unfinished_color, this.default_unfinished_color);
        this.enableWave = attributes.getBoolean(R.styleable.MyProgressWave_wave_enable, true);
        this.circleColor = attributes.getColor(R.styleable.MyProgressWave_wave_circle_color, this.finishedColor);
        this.textColor = attributes.getColor(R.styleable.MyProgressWave_wave_text_color, -1);
        this.textSize = attributes.getDimension(R.styleable.MyProgressWave_wave_text_size, this.default_text_size);
        this.circleWidth = attributes.getDimension(R.styleable.MyProgressWave_wave_circle_width, this.default_circle_width);
        this.enableCenterText = attributes.getBoolean(R.styleable.MyProgressWave_wave_enable_center_text, false);
        this.style = attributes.getInt(R.styleable.MyProgressWave_wave_style, 0);
        this.setMax(attributes.getInt(R.styleable.MyProgressWave_wave_max, 100));
        this.setProgress(attributes.getFloat(R.styleable.MyProgressWave_wave_progress, 0.0f));
        if (attributes.getString(R.styleable.MyProgressWave_wave_prefix_text) != null) {
            this.setPrefixText(attributes.getString(R.styleable.MyProgressWave_wave_prefix_text));
        }
        if (attributes.getString(R.styleable.MyProgressWave_wave_suffix_text) != null) {
            this.setSuffixText(attributes.getString(R.styleable.MyProgressWave_wave_suffix_text));
        }
        if (attributes.getString(R.styleable.MyProgressWave_wave_force_title) != null) {
            this.setForceTitle(attributes.getString(R.styleable.MyProgressWave_wave_force_title));
        }
    }

    protected void initPainters() {
        this.textPaint = new TextPaint();
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        this.textPaint.setAntiAlias(true);
        this.paint.setAntiAlias(true);
    }

    public void invalidate() {
        this.initPainters();
        super.invalidate();
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        if (this.progress > (float)this.getMax()) {
            this.progress = this.getMax();
        }
        this.invalidate();
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        if (max > 0) {
            this.max = max;
            this.invalidate();
        }
    }

    public float getTextSize() {
        return this.textSize;
    }

    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.invalidate();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public void setTextColor(int textColor) {
        this.textColor = textColor;
        this.invalidate();
    }

    public int getFinishedColor() {
        return this.finishedColor;
    }

    public void setFinishedColor(int finishedColor) {
        this.finishedColor = finishedColor;
        this.invalidate();
    }

    public int getUnfinishedColor() {
        return this.unfinishedColor;
    }

    public void setUnfinishedColor(int unfinishedColor) {
        this.unfinishedColor = unfinishedColor;
        this.invalidate();
    }

    public String getPrefixText() {
        return this.prefixText;
    }

    public void setPrefixText(String prefixText) {
        this.prefixText = prefixText;
        this.invalidate();
    }

    public String getSuffixText() {
        return this.suffixText;
    }

    public void setSuffixText(String suffixText) {
        this.suffixText = suffixText;
        this.invalidate();
    }

    public String getDrawText() {
        if (this.forceTitle != null) {
            return this.getForceTitle();
        }
        if (!this.enableCenterText) {
            return null;
        }
        return this.getPrefixText() + this.getProgress() + this.getSuffixText();
    }

    public float getProgressPercentage() {
        return this.getProgress() / (float)this.getMax();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.rectF.set(0.0f, 0.0f, (float)View.MeasureSpec.getSize((int)widthMeasureSpec), (float)View.MeasureSpec.getSize((int)heightMeasureSpec));
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    private float getLineHeight(int x, float h) {
        if (this.enableWave) {
            return (float)(6.0 * Math.sin((double)x * (1.0 / this.periodMultiple)) + (double)this.getHeight() - (double)h);
        }
        return (float)this.getHeight() - h;
    }

    protected void onDraw(Canvas canvas) {
        float yHeight = this.getProgress() / (float)this.getMax() * (float)this.getHeight();
        float radius = (float)this.getWidth() / 2.0f;
        int saveLayerCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.paint, 31);
        if (this.mMaskBitmap == null) {
            this.mMaskBitmap = this.getMaskBitmap(radius);
        }
        this.paint.setFilterBitmap(true);
        canvas.drawBitmap(this.mMaskBitmap, 0.0f, 0.0f, this.paint);
        this.paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_ATOP));
        this.paint.setAntiAlias(true);
        if (this.changeHeight) {
            this.mWaveBitmap = this.getWaveBitmap(yHeight);
            canvas.drawBitmap(this.mWaveBitmap, (float)((double)this.offset / (1.0 / this.periodMultiple)), 0.0f, this.paint);
            this.changeHeight = false;
        } else {
            if (this.mWaveBitmap == null) {
                this.mWaveBitmap = this.getWaveBitmap(yHeight);
            }
            canvas.drawBitmap(this.mWaveBitmap, (float)((double)this.offset / (1.0 / this.periodMultiple)), 0.0f, this.paint);
        }
        this.paint.setXfermode(null);
        canvas.restoreToCount(saveLayerCount);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(this.circleWidth);
        this.paint.setColor(this.circleColor);
        switch (this.style) {
            case 0: {
                canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), radius - this.circleWidth / 2.0f, this.paint);
                break;
            }
            case 1: {
                canvas.drawRect(this.circleWidth / 2.0f, this.circleWidth / 2.0f, (float)this.getWidth() - this.circleWidth / 2.0f, (float)this.getHeight() - this.circleWidth / 2.0f, this.paint);
            }
        }
        String text = this.getDrawText();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            float textHeight = this.textPaint.descent() + this.textPaint.ascent();
            canvas.drawText(text, ((float)this.getWidth() - this.textPaint.measureText(text)) / 2.0f, ((float)this.getWidth() - textHeight) / 2.0f, this.textPaint);
        }
    }

    private Bitmap getMaskBitmap(float radius) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint lpaint = new Paint();
        lpaint.setAntiAlias(true);
        lpaint.setStyle(Paint.Style.FILL);
        lpaint.setColor(this.getUnfinishedColor());
        switch (this.style) {
            case 0: {
                canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), radius, lpaint);
                break;
            }
            case 1: {
                canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), lpaint);
            }
        }
        return bitmap;
    }

    private Bitmap getWaveBitmap(float yHeight) {
        int width = (int)((double)((int)((double)this.getWidth() / (Math.PI * 2 / (1.0 / this.periodMultiple))) + 2) * (Math.PI * 2 / (1.0 / this.periodMultiple)));
        Log.d((String)TAG, (String)("getWaveBitmap: w" + width));
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint lpaint = new Paint();
        lpaint.setColor(this.getFinishedColor());
        for (int i = 0; i <= width; ++i) {
            canvas.drawLine((float)i, this.getLineHeight(i, yHeight), (float)i, (float)this.getHeight(), lpaint);
        }
        return bitmap;
    }

    public void StartWave() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (MyProgressWave.this.enableWave) {
                    try {
                        Thread.sleep(20L);
                        MyProgressWave.this.offset = (float)((double)MyProgressWave.this.offset - 0.13);
                        if ((double)MyProgressWave.this.offset <= Math.PI * -2) {
                            MyProgressWave.this.offset = (float)((double)MyProgressWave.this.offset + Math.PI * 2);
                        }
                        Message message = new Message();
                        message.what = 1;
                        MyProgressWave.this.mHandler.sendMessage(message);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }).start();
    }
}

