/*
 * Decompiled with CFR 0.152.
 */
package top.guuguo.progress_lib.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import top.guuguo.progress_lib.R;
import top.guuguo.progress_lib.util.DensityUtil;

public class MyProgressRoundBarView
extends View {
    private Drawable icon;
    private Paint mPaint;
    private float mIntervalNone = 1.0f;
    private float mInterval = 1.0f;
    private int mProgress;
    private int mStartAngle;
    private int mEndAngle;
    private float mCenterTextSize;
    private int mProgressMax;
    private int mCenterTextColor;
    private int mFinishedColor;
    private float mProgressWidth;
    private int mUnfinishedColor;
    private String mCenterText;
    private Camera camera = new Camera();
    private float mPadding = 30.0f;
    private int mRotateProgress = 0;
    private Bitmap mWaveBitmap;
    private Bitmap mProgressBitmap;
    int changeInt = 5;

    public float getmRotateProgress() {
        return this.mRotateProgress;
    }

    public void setmRotateProgress(int mRotateProgress) {
        if (100 - mRotateProgress >= 2 && Math.abs(this.mRotateProgress - mRotateProgress) <= 2) {
            return;
        }
        this.mRotateProgress = mRotateProgress;
        this.refreshImage();
    }

    public int getmProgressMax() {
        return this.mProgressMax;
    }

    public void setmProgressMax(int mProgressMax) {
        this.mProgressMax = mProgressMax;
    }

    public int getmProgress() {
        return this.mProgress;
    }

    public void setmProgress(int mProgress) {
        this.mProgress = mProgress;
    }

    public int getmCenterTextColor() {
        return this.mCenterTextColor;
    }

    public void setmCenterTextColor(int mCenterTextColor) {
        this.mCenterTextColor = mCenterTextColor;
    }

    public int getmFinishedColor() {
        return this.mFinishedColor;
    }

    public void setmFinishedColor(int mFinishedColor) {
        this.mFinishedColor = mFinishedColor;
    }

    public int getmUnfinishedColor() {
        return this.mUnfinishedColor;
    }

    public void setmUnfinishedColor(int mUnfinishedColor) {
        this.mUnfinishedColor = mUnfinishedColor;
    }

    public String getmCenterText() {
        return this.mCenterText;
    }

    public void setmCenterText(String mCenterText) {
        this.mCenterText = mCenterText;
    }

    public MyProgressRoundBarView(Context context) {
        this(context, null);
    }

    public MyProgressRoundBarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MyProgressRoundBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MyProgressRoundBarView, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPaint();
    }

    protected void initByAttributes(TypedArray attributes) {
        this.mProgress = attributes.getInteger(R.styleable.MyProgressRoundBarView_round_bar_progress, 0);
        this.mProgressMax = attributes.getInteger(R.styleable.MyProgressRoundBarView_round_bar_progress_max, 100);
        this.mStartAngle = attributes.getInteger(R.styleable.MyProgressRoundBarView_round_bar_progress_startangle, 135);
        this.mEndAngle = attributes.getInteger(R.styleable.MyProgressRoundBarView_round_bar_progress_endangle, 405);
        this.mCenterTextColor = attributes.getColor(R.styleable.MyProgressRoundBarView_round_bar_center_text_color, -16777216);
        this.mCenterText = attributes.getString(R.styleable.MyProgressRoundBarView_round_bar_center_text);
        this.mFinishedColor = attributes.getColor(R.styleable.MyProgressRoundBarView_round_bar_finished_color, -16776961);
        this.mUnfinishedColor = attributes.getColor(R.styleable.MyProgressRoundBarView_round_bar_unfinished_color, -7829368);
        this.mCenterTextSize = attributes.getDimension(R.styleable.MyProgressRoundBarView_round_bar_center_text_size, (float)DensityUtil.dip2px(this.getContext(), 25.0f));
        this.mProgressWidth = attributes.getDimension(R.styleable.MyProgressRoundBarView_round_bar_width, (float)DensityUtil.dip2px(this.getContext(), 2.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        if (this.mRotateProgress != 0) {
            this.CameraCanvas(canvas);
        } else {
            this.mProgressBitmap = this.getProgressBitmapComplet();
        }
        canvas.drawBitmap(this.mProgressBitmap, 0.0f, 0.0f, this.mPaint);
        canvas.restore();
        if (this.mCenterText != null && this.mCenterText.equals("")) {
            return;
        }
        this.mPaint.setColor(this.mCenterTextColor);
        Rect textBounds = new Rect();
        this.mPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mPaint.setTextSize(this.mCenterTextSize);
        if (this.mCenterText != null) {
            this.mPaint.getTextBounds(this.mCenterText, 0, this.mCenterText.length(), textBounds);
            int textHeight = textBounds.bottom - textBounds.top;
            canvas.drawText(this.mCenterText, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2 + textHeight / 2), this.mPaint);
        } else {
            String text = this.mProgress * 100 / this.mProgressMax + "%";
            this.mPaint.getTextBounds(text, 0, text.length(), textBounds);
            int textHeight = textBounds.bottom - textBounds.top;
            canvas.drawText(text, (float)(this.getWidth() / 2), (float)(this.getHeight() / 2 + textHeight / 2), this.mPaint);
        }
    }

    public void refreshImage() {
        this.invalidate();
    }

    private void CameraCanvas(Canvas canvas) {
        this.camera.save();
        Matrix matrix = new Matrix();
        this.camera.rotateX((float)(90 * this.mRotateProgress / 100));
        this.camera.getMatrix(matrix);
        matrix.preTranslate((float)(-this.getWidth() >> 1), (float)(-this.getHeight() >> 1));
        matrix.postTranslate((float)(this.getWidth() >> 1), (float)(this.getHeight() >> 1));
        this.camera.restore();
        canvas.concat(matrix);
    }

    private Bitmap getMaskBitmap(float radius) {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        Paint lpaint = new Paint();
        lpaint.setAntiAlias(true);
        lpaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), radius, lpaint);
        return bitmap;
    }

    private Bitmap getProgressBitmap() {
        float lAngle;
        int i;
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        int allSectorNum = (int)this.getAllSectorNum();
        Paint lpaint = new Paint();
        lpaint.setAntiAlias(true);
        lpaint.setColor(this.mFinishedColor);
        int finishNum = allSectorNum * this.mProgress / this.mProgressMax;
        for (i = 0; i < finishNum; ++i) {
            lAngle = (float)this.mStartAngle + (float)i * (this.mIntervalNone + this.mInterval);
            canvas.drawArc(new RectF(this.mPadding, this.mPadding, (float)this.getWidth() - this.mPadding, (float)this.getHeight() - this.mPadding), lAngle, this.mInterval, true, lpaint);
        }
        lpaint.setColor(this.mUnfinishedColor);
        for (i = finishNum; i < allSectorNum; ++i) {
            lAngle = (float)this.mStartAngle + (float)i * (this.mIntervalNone + this.mInterval);
            canvas.drawArc(new RectF(this.mPadding, this.mPadding, (float)this.getWidth() - this.mPadding, (float)this.getHeight() - this.mPadding), lAngle, this.mInterval, true, lpaint);
        }
        return bitmap;
    }

    private Bitmap getProgressBitmapComplet() {
        Bitmap bitmap = Bitmap.createBitmap((int)this.getWidth(), (int)this.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        int saveLayerCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint, 31);
        Paint lPaint = new Paint();
        lPaint.setAntiAlias(true);
        lPaint.setStyle(Paint.Style.FILL);
        lPaint.setColor(-1);
        canvas.drawCircle((float)(this.getWidth() / 2), (float)(this.getWidth() / 2), (float)(this.getWidth() / 2) - this.mProgressWidth - this.mPadding, lPaint);
        lPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        this.mWaveBitmap = this.getProgressBitmap();
        canvas.drawBitmap(this.mWaveBitmap, 0.0f, 0.0f, lPaint);
        canvas.restoreToCount(saveLayerCount);
        lPaint.setXfermode(null);
        return bitmap;
    }

    private float getAllSectorNum() {
        return ((float)Math.abs(this.mStartAngle - this.mEndAngle) + this.mIntervalNone) / (this.mInterval + this.mIntervalNone);
    }
}

