/*
 * Decompiled with CFR 0.152.
 */
package top.guuguo.progress_lib.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import top.guuguo.progress_lib.R;
import top.guuguo.progress_lib.util.DensityUtil;

public class MyProgressInstrument
extends View {
    private Drawable icon;
    private Paint mPaint;
    private int mProgress = 0;
    private float mCenterTextSize;
    private int mProgressMax;
    private int mCenterTextColor;
    private int mFinishedColor;
    private int mBackgroundColor;
    private String mCenterText = "";
    private Bitmap mBgBitmap;
    int currentProgress;

    public int getmProgressMax() {
        return this.mProgressMax;
    }

    public void setmProgressMax(int mProgressMax) {
        this.mProgressMax = mProgressMax;
    }

    public int getmProgress() {
        return this.mProgress;
    }

    public void setmProgress(int mProgress) {
        this.mProgress = mProgress;
        this.progressAnimation();
    }

    private void progressAnimation() {
    }

    public int getmCenterTextColor() {
        return this.mCenterTextColor;
    }

    public void setmCenterTextColor(int mCenterTextColor) {
        this.mCenterTextColor = mCenterTextColor;
    }

    public int getmFinishedColor() {
        return this.mFinishedColor;
    }

    public void setmFinishedColor(int mFinishedColor) {
        this.mFinishedColor = mFinishedColor;
    }

    public String getmCenterText() {
        return this.mCenterText;
    }

    public void setmCenterText(String mCenterText) {
        this.mCenterText = mCenterText;
    }

    public MyProgressInstrument(Context context) {
        this(context, null);
    }

    public MyProgressInstrument(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MyProgressInstrument(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MyProgressInstrument, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPaint();
    }

    protected void initByAttributes(TypedArray attributes) {
        this.mProgress = attributes.getInteger(R.styleable.MyProgressInstrument_Instrument_progress, 0);
        this.mProgressMax = attributes.getInteger(R.styleable.MyProgressInstrument_Instrument_progress_max, 100);
        this.mCenterTextColor = attributes.getColor(R.styleable.MyProgressInstrument_Instrument_center_text_color, -16777216);
        if (attributes.getString(R.styleable.MyProgressInstrument_Instrument_center_text) != null) {
            this.mCenterText = attributes.getString(R.styleable.MyProgressInstrument_Instrument_center_text);
        }
        this.mFinishedColor = attributes.getColor(R.styleable.MyProgressInstrument_Instrument_finished_color, -16776961);
        this.mBackgroundColor = attributes.getColor(R.styleable.MyProgressInstrument_Instrument_background_color, -16777216);
        this.mCenterTextSize = attributes.getDimension(R.styleable.MyProgressInstrument_Instrument_center_text_size, (float)DensityUtil.dip2px(this.getContext(), 25.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mBgBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.progress_instrument_bg);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mBackgroundColor);
        int saveLayerCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint, 31);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        canvas.drawBitmap(this.mBgBitmap, new Rect(0, 0, this.mBgBitmap.getWidth(), this.mBgBitmap.getHeight()), new Rect(0, 0, this.getWidth(), this.getHeight()), this.mPaint);
        this.mPaint.setXfermode(null);
        canvas.restoreToCount(saveLayerCount);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setFilterBitmap(false);
        this.mPaint.setColor(this.mFinishedColor);
        canvas.drawArc(new RectF(0.0f, 0.0f, (float)this.getHeight(), (float)this.getHeight()), 0.0f, (float)(200 * this.mProgress / this.mProgressMax), true, this.mPaint);
        canvas.save();
        canvas.rotate((float)(200 * this.mProgress / this.mProgressMax), (float)(this.getWidth() / 2), (float)(this.getHeight() / 2));
        this.mPaint.setColor(this.mBackgroundColor);
        this.mPaint.setStrokeWidth(5.0f);
        canvas.drawLine((float)(this.getWidth() / 2), (float)(this.getHeight() / 2), (float)this.getWidth(), (float)(this.getHeight() / 2), this.mPaint);
        canvas.restore();
    }
}

