/*
 * Decompiled with CFR 0.152.
 */
package top.guuguo.progress_lib.view;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import top.guuguo.progress_lib.R;
import top.guuguo.progress_lib.util.DensityUtil;

public class MyProgressHalfCircleBarView
extends View {
    private Drawable icon;
    private Paint mPaint;
    private int mProgress = 0;
    private float mCenterTextSize;
    private int mProgressMax;
    private int mCenterTextColor;
    private int mFinishedColor;
    private float mProgressWidth;
    private int mUnfinishedColor;
    private int mBackgroundColor;
    private String mCenterText = "";
    private Bitmap mBgBitmap;
    int currentProgress;

    public int getmProgressMax() {
        return this.mProgressMax;
    }

    public void setmProgressMax(int mProgressMax) {
        this.mProgressMax = mProgressMax;
    }

    public int getmProgress() {
        return this.mProgress;
    }

    public void setmProgress(int mProgress) {
        this.mProgress = mProgress;
        this.progressAnimation();
    }

    private void progressAnimation() {
    }

    public int getmCenterTextColor() {
        return this.mCenterTextColor;
    }

    public void setmCenterTextColor(int mCenterTextColor) {
        this.mCenterTextColor = mCenterTextColor;
    }

    public int getmFinishedColor() {
        return this.mFinishedColor;
    }

    public void setmFinishedColor(int mFinishedColor) {
        this.mFinishedColor = mFinishedColor;
    }

    public int getmUnfinishedColor() {
        return this.mUnfinishedColor;
    }

    public void setmUnfinishedColor(int mUnfinishedColor) {
        this.mUnfinishedColor = mUnfinishedColor;
    }

    public String getmCenterText() {
        return this.mCenterText;
    }

    public void setmCenterText(String mCenterText) {
        this.mCenterText = mCenterText;
    }

    public MyProgressHalfCircleBarView(Context context) {
        this(context, null);
    }

    public MyProgressHalfCircleBarView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MyProgressHalfCircleBarView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MyProgressHalfCircleBarView, defStyleAttr, 0);
        this.initByAttributes(attributes);
        attributes.recycle();
        this.initPaint();
    }

    protected void initByAttributes(TypedArray attributes) {
        this.mProgress = attributes.getInteger(R.styleable.MyProgressHalfCircleBarView_half_progress, 0);
        this.mProgressMax = attributes.getInteger(R.styleable.MyProgressHalfCircleBarView_half_progress_max, 100);
        this.mCenterTextColor = attributes.getColor(R.styleable.MyProgressHalfCircleBarView_half_center_text_color, -16777216);
        if (attributes.getString(R.styleable.MyProgressHalfCircleBarView_half_center_text) != null) {
            this.mCenterText = attributes.getString(R.styleable.MyProgressHalfCircleBarView_half_center_text);
        }
        this.mFinishedColor = attributes.getColor(R.styleable.MyProgressHalfCircleBarView_half_finished_color, -16776961);
        this.mUnfinishedColor = attributes.getColor(R.styleable.MyProgressHalfCircleBarView_half_unfinished_color, -7829368);
        this.mBackgroundColor = attributes.getColor(R.styleable.MyProgressHalfCircleBarView_half_background_color, this.mUnfinishedColor);
        this.mCenterTextSize = attributes.getDimension(R.styleable.MyProgressHalfCircleBarView_half_center_text_size, (float)DensityUtil.dip2px(this.getContext(), 25.0f));
        this.mProgressWidth = attributes.getDimension(R.styleable.MyProgressHalfCircleBarView_half_width, (float)DensityUtil.dip2px(this.getContext(), 15.0f));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mBgBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.heart_rat_progress_bg);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.save();
        this.mPaint.setStrokeWidth(this.mProgressWidth);
        int saveLayerCount = canvas.saveLayer(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint, 31);
        this.mPaint.setFilterBitmap(true);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(this.mBackgroundColor);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint);
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP));
        canvas.drawBitmap(this.mBgBitmap, new Rect(0, 0, this.mBgBitmap.getWidth(), this.mBgBitmap.getHeight()), new Rect(0, 0, this.getWidth(), this.getHeight()), this.mPaint);
        this.mPaint.setXfermode(null);
        this.mPaint.setStyle(Paint.Style.STROKE);
        canvas.restoreToCount(saveLayerCount);
        float margin = 0.14285715f;
        float y = (float)this.getHeight() * margin;
        float x = (float)(this.getWidth() / 2 - this.getHeight()) + y;
        this.mPaint.setColor(this.mUnfinishedColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setFilterBitmap(false);
        canvas.drawArc(new RectF(x, y, x + (float)(2 * this.getHeight()) * (1.0f - margin), y + (float)(2 * this.getHeight()) * (1.0f - margin)), 180.0f, 180.0f, false, this.mPaint);
        this.mPaint.setColor(this.mFinishedColor);
        this.mPaint.setStrokeWidth(this.mProgressWidth);
        canvas.drawArc(new RectF(x, y, x + (float)(2 * this.getHeight()) * (1.0f - margin), y + (float)(2 * this.getHeight()) * (1.0f - margin)), 180.0f, (float)(180 * this.mProgress / this.mProgressMax), false, this.mPaint);
        Rect textBounds = new Rect();
        this.mPaint.reset();
        this.mPaint.setColor(this.mCenterTextColor);
        this.mPaint.setTextSize(this.mCenterTextSize);
        this.mPaint.getTextBounds(this.mCenterText, 0, this.mCenterText.length(), textBounds);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        int textHeight = textBounds.bottom - textBounds.top;
        canvas.drawText(this.mCenterText, (float)(this.getWidth() / 2), (float)(this.getHeight() - textHeight / 2), this.mPaint);
    }
}

