/*
 * Decompiled with CFR 0.152.
 */
package top.carlwu.simple_keyboard;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.widget.EditText;
import java.lang.ref.WeakReference;
import java.util.List;
import top.carlwu.simple_keyboard.KeyBoardCallback;
import top.carlwu.simple_keyboard.KeyBoardInputType;
import top.carlwu.simple_keyboard.R;

class KhKeyboardView {
    private static final String TAG = KhKeyboardView.class.getSimpleName();
    private Context mContext;
    private KeyboardView keyboardView;
    private Keyboard mNumberKeyboard;
    private Keyboard mLetterKeyboard;
    private Keyboard mSymbolKeyboard;
    private KeyBoardInputType inputType = KeyBoardInputType.INPUT_TYPE_DEFAULT;
    private int keyboardState = 0;
    public static boolean isUpper = false;
    private boolean isSymbol = false;
    private EditText mEditText;
    private Dialog mDialog;
    private KeyboardView.OnKeyboardActionListener listener = new KeyboardView.OnKeyboardActionListener(){

        public void onPress(int primaryCode) {
        }

        public void onRelease(int primaryCode) {
            Log.d((String)"primaryCode", (String)("onRelease--" + primaryCode));
            try {
                if (KhKeyboardView.this.mEditText == null) {
                    return;
                }
                Editable editable = KhKeyboardView.this.mEditText.getText();
                int start = KhKeyboardView.this.mEditText.getSelectionStart();
                if (primaryCode == -3) {
                    KhKeyboardView.this.hideKeyboard();
                } else if (primaryCode == -5) {
                    if (editable != null && editable.length() > 0 && start > 0) {
                        editable.delete(start - 1, start);
                    }
                } else if (primaryCode == -1) {
                    KhKeyboardView.this.changeKeyboart();
                } else if (primaryCode == -2) {
                    if (KhKeyboardView.this.keyboardState == 0) {
                        KhKeyboardView.this.changeKeyboardState(1);
                    } else {
                        KhKeyboardView.this.changeKeyboardState(0);
                    }
                } else if (primaryCode == -4) {
                    KhKeyboardView.this.hideKeyboard();
                } else if (primaryCode == 90001) {
                    KhKeyboardView.this.changeKeyboardState(2);
                } else {
                    editable.insert(start, (CharSequence)Character.toString((char)primaryCode));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onKey(int primaryCode, int[] keyCodes) {
            Log.d((String)"primaryCode", (String)("onKey--" + primaryCode));
        }

        public void onText(CharSequence text) {
        }

        public void swipeLeft() {
        }

        public void swipeRight() {
        }

        public void swipeDown() {
        }

        public void swipeUp() {
        }
    };

    public KhKeyboardView(Activity context) {
        this.mContext = context;
        View view = LayoutInflater.from((Context)context).inflate(R.layout.keyboard_key_board_popu, null);
        this.mDialog = new Dialog((Context)context, R.style.keyboard_popupAnimation);
        this.mDialog.setContentView(view);
        this.mDialog.setCanceledOnTouchOutside(true);
        Window mWindow = this.mDialog.getWindow();
        mWindow.setWindowAnimations(R.style.keyboard_popupAnimation);
        mWindow.setSoftInputMode(3);
        mWindow.setGravity(81);
        mWindow.setLayout(-2, -2);
        this.mNumberKeyboard = new Keyboard(this.mContext, R.xml.keyboard_numbers);
        this.mLetterKeyboard = new Keyboard(this.mContext, R.xml.keyboard_word);
        this.mSymbolKeyboard = new Keyboard(this.mContext, R.xml.keyboard_symbol);
        this.keyboardView = (KeyboardView)view.findViewById(R.id.keyboard_view);
        this.keyboardView.setEnabled(true);
        this.keyboardView.setPreviewEnabled(false);
        this.keyboardView.setOnKeyboardActionListener(this.listener);
        this.changeKeyboardState(0);
    }

    private void changeKeyboardState(int newState) {
        switch (newState) {
            case 1: {
                this.keyboardView.setKeyboard(this.mSymbolKeyboard);
                break;
            }
            case 2: {
                this.keyboardView.setKeyboard(this.mNumberKeyboard);
                break;
            }
            default: {
                this.keyboardView.setKeyboard(this.mLetterKeyboard);
                newState = 0;
            }
        }
        this.keyboardState = newState;
    }

    private void changeKeyboart() {
        isUpper = !isUpper;
        List keyList = this.mLetterKeyboard.getKeys();
        for (Keyboard.Key key : keyList) {
            if (key.label != null && this.isLetter(key.label.toString())) {
                if (key.codes[0] >= 65 && key.codes[0] <= 90) {
                    key.label = key.label.toString().toLowerCase();
                    key.codes[0] = key.codes[0] + 32;
                    continue;
                }
                if (key.codes[0] < 97 || key.codes[0] > 122) continue;
                key.label = key.label.toString().toUpperCase();
                key.codes[0] = key.codes[0] - 32;
                continue;
            }
            if (key.codes[0] != -1) continue;
            if (isUpper) {
                key.icon = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.icon_keyboard_capital_selected);
                continue;
            }
            key.icon = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.icon_keyboard_capital_default);
        }
        this.keyboardView.invalidateAllKeys();
    }

    private boolean isLetter(String str) {
        String wordStr = "abcdefghijklmnopqrstuvwxyz";
        return wordStr.contains(str.toLowerCase());
    }

    private void hideKeyboard() {
        Log.d((String)TAG, (String)"hideKeyboard: ");
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public Dialog showKeyboard(final EditText editText, final WeakReference<KeyBoardCallback> callback, KeyBoardInputType inputType) {
        this.mEditText = editText;
        this.inputType = inputType;
        switch (inputType) {
            case INPUT_TYPE_NUM_FINISH: 
            case INPUT_TYPE_NUM_POINT: 
            case INPUT_TYPE_NUM_X: {
                this.updateKeyBoard();
                this.changeKeyboardState(2);
                break;
            }
            default: {
                this.changeKeyboardState(0);
            }
        }
        this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                editText.clearFocus();
                if (callback != null && callback.get() != null) {
                    ((KeyBoardCallback)callback.get()).onKeyBoardShow();
                }
            }
        });
        this.mDialog.show();
        return this.mDialog;
    }

    private void updateKeyBoard() {
        Keyboard.Key shiftKey = null;
        for (Keyboard.Key key : this.mNumberKeyboard.getKeys()) {
            if (key.codes[0] != -2) continue;
            shiftKey = key;
            break;
        }
        if (shiftKey != null) {
            switch (this.inputType) {
                case INPUT_TYPE_NUM_FINISH: {
                    shiftKey.label = "\u5b8c\u6210";
                    shiftKey.codes[0] = -4;
                    break;
                }
                case INPUT_TYPE_NUM_POINT: {
                    shiftKey.label = ".";
                    shiftKey.codes[0] = 46;
                    break;
                }
                case INPUT_TYPE_NUM_X: {
                    shiftKey.label = "X";
                    shiftKey.codes[0] = 88;
                }
            }
        }
    }
}

