/*
 * Decompiled with CFR 0.152.
 */
package top.carlwu.simple_keyboard;

import android.app.Activity;
import android.app.Dialog;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import top.carlwu.simple_keyboard.KeyBoardCallback;
import top.carlwu.simple_keyboard.KeyBoardInputType;
import top.carlwu.simple_keyboard.KhKeyboardView;

public class KeyBoardDialogUtils {
    private static WeakReference<Dialog> mDialogWeakReference;
    private static WeakReference<KeyBoardCallback> mKeyBoardCallback;

    private static void hideSoftInputMethod(Activity activity, EditText ed) {
        activity.getWindow().setSoftInputMode(3);
        int currentVersion = Build.VERSION.SDK_INT;
        String methodName = null;
        if (currentVersion >= 16) {
            methodName = "setShowSoftInputOnFocus";
        } else if (currentVersion >= 14) {
            methodName = "setSoftInputShownOnFocus";
        }
        if (methodName == null) {
            ed.setInputType(0);
        } else {
            Class<EditText> cls = EditText.class;
            try {
                Method setShowSoftInputOnFocus = cls.getMethod(methodName, Boolean.TYPE);
                setShowSoftInputOnFocus.setAccessible(true);
                setShowSoftInputOnFocus.invoke((Object)ed, false);
            }
            catch (Exception e) {
                e.printStackTrace();
                ed.setInputType(0);
            }
        }
    }

    private static Dialog show(Activity activity, EditText editText, WeakReference<KeyBoardCallback> callback, KeyBoardInputType inputType) {
        KeyBoardDialogUtils.hideSoftInputMethod(activity, editText);
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        editText.setCursorVisible(true);
        editText.setSelection(editText.getText().toString().length());
        KhKeyboardView keyboardView = new KhKeyboardView(activity);
        return keyboardView.showKeyboard(editText, callback, inputType);
    }

    public static void registerCustomInputMethod(Activity activity, EditText editText, KeyBoardCallback callback) {
        KeyBoardDialogUtils.registerCustomInputMethod(activity, editText, callback, KeyBoardInputType.INPUT_TYPE_DEFAULT);
    }

    public static void registerCustomInputMethod(final Activity activity, final EditText editText, KeyBoardCallback callback, final KeyBoardInputType inputType) {
        mKeyBoardCallback = new WeakReference<KeyBoardCallback>(callback);
        editText.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == 1) {
                    Dialog dialog = KeyBoardDialogUtils.show(activity, editText, mKeyBoardCallback, inputType);
                    mDialogWeakReference = new WeakReference<Dialog>(dialog);
                    if (mKeyBoardCallback != null && mKeyBoardCallback.get() != null) {
                        ((KeyBoardCallback)mKeyBoardCallback.get()).onKeyBoardShow();
                    }
                }
                return false;
            }
        });
    }

    public static void dissmissInputDialog() {
        Dialog dialog;
        if (mDialogWeakReference != null && (dialog = (Dialog)mDialogWeakReference.get()) != null && dialog.isShowing()) {
            dialog.dismiss();
            if (mKeyBoardCallback != null && mKeyBoardCallback.get() != null) {
                ((KeyBoardCallback)mKeyBoardCallback.get()).onKeyBoardShow();
            }
        }
    }
}

