package top.carlwu.simple_keyboard;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.inputmethodservice.Keyboard;
import android.inputmethodservice.KeyboardView;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;


import java.lang.ref.WeakReference;
import java.util.List;

class KhKeyboardView {
    private static final String TAG = KhKeyboardView.class.getSimpleName();
    private Context mContext;
    private KeyboardView keyboardView;   //键盘View
    private Keyboard mNumberKeyboard;   // 数字键盘
    private Keyboard mLetterKeyboard;   // 字母键盘
    private Keyboard mSymbolKeyboard;   // 符号键盘
    private KeyBoardInputType inputType = KeyBoardInputType.INPUT_TYPE_DEFAULT;
    private int keyboardState = 0;    // 键盘状态  0：字母   1：符号  2：数字
    public static boolean isUpper = false;    // 是否大写
    private boolean isSymbol = false;   // 是否是符号
    private EditText mEditText;
    private Dialog mDialog;


    public KhKeyboardView(Activity context) {
        mContext = context;

        View view = LayoutInflater.from(context).inflate(R.layout.keyboard_key_board_popu, null);

        mDialog = new Dialog(context, R.style.keyboard_popupAnimation);
        mDialog.setContentView(view);
        mDialog.setCanceledOnTouchOutside(true);
        Window mWindow = mDialog.getWindow();
        mWindow.setWindowAnimations(R.style.keyboard_popupAnimation);
        mWindow.setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
        mWindow.setGravity(Gravity.BOTTOM | Gravity.CENTER_HORIZONTAL);
        mWindow.setLayout(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);

        mNumberKeyboard = new Keyboard(mContext, R.xml.keyboard_numbers);
        mLetterKeyboard = new Keyboard(mContext, R.xml.keyboard_word);
        mSymbolKeyboard = new Keyboard(mContext, R.xml.keyboard_symbol);
        keyboardView = (KeyboardView) view.findViewById(R.id.keyboard_view);

        keyboardView.setEnabled(true);
        keyboardView.setPreviewEnabled(false);
        keyboardView.setOnKeyboardActionListener(listener);
        changeKeyboardState(0);
    }

    private KeyboardView.OnKeyboardActionListener listener = new KeyboardView.OnKeyboardActionListener() {
        /**
         * 按下，在onKey之前，可以在这里做一些操作，这里让有的没有按下的悬浮提示
         * @param primaryCode
         */
        @Override
        public void onPress(int primaryCode) {
        }

        /**
         * 松开
         * @param primaryCode
         */
        @Override
        public void onRelease(int primaryCode) {
            Log.d("primaryCode", "onRelease--" + primaryCode);
            try {
                if (mEditText == null)
                    return;
                Editable editable = mEditText.getText();
                int start = mEditText.getSelectionStart();
                if (primaryCode == Keyboard.KEYCODE_CANCEL) {
                    // 隐藏键盘
                    hideKeyboard();
                } else if (primaryCode == Keyboard.KEYCODE_DELETE) {   // 回退键,删除字符
                    if (editable != null && editable.length() > 0) {
                        if (start > 0) {
                            editable.delete(start - 1, start);
                        }
                    }
                } else if (primaryCode == Keyboard.KEYCODE_SHIFT) {
                    // 大小写切换
                    changeKeyboart();
                } else if (primaryCode == Keyboard.KEYCODE_MODE_CHANGE) {//处理字母与符号键盘切换
                    if (keyboardState == 0) {// 字母键盘切换到符号键盘
                        changeKeyboardState(1);
                    } else {// 符号或数字键盘切换到字母键盘
                        changeKeyboardState(0);
                    }

                } else if (primaryCode == Keyboard.KEYCODE_DONE) {//处理完成事件
                    hideKeyboard();
                } else if (primaryCode == 90001) {//处理切换到数字键盘
                    changeKeyboardState(2);
                } else {
                    // 输入键盘值
                    editable.insert(start, Character.toString((char) primaryCode));
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

        /**
         * 按下
         * @param primaryCode
         * @param keyCodes
         */
        @Override
        public void onKey(int primaryCode, int[] keyCodes) {
            Log.d("primaryCode", "onKey--" + primaryCode);

        }

        @Override
        public void onText(CharSequence text) {

        }

        @Override
        public void swipeLeft() {

        }

        @Override
        public void swipeRight() {

        }

        @Override
        public void swipeDown() {

        }

        @Override
        public void swipeUp() {

        }
    };

    // 数字-字母, 显示数字键盘
    private void changeKeyboardState(int newState) {
        switch (newState) {
            case 1:
                keyboardView.setKeyboard(mSymbolKeyboard);
                break;
            case 2:
                keyboardView.setKeyboard(mNumberKeyboard);
                break;
            default:
                keyboardView.setKeyboard(mLetterKeyboard);
                newState = 0;
                break;
        }
        keyboardState = newState;
    }

    /**
     * 切换大小写
     */
    private void changeKeyboart() {
        isUpper = !isUpper;
        List<Keyboard.Key> keyList = mLetterKeyboard.getKeys();
        for (Keyboard.Key key : keyList) {
            if (key.label != null && isLetter(key.label.toString())) {
                if (key.codes[0] >= 65 && key.codes[0] <= 90) {//大写字母
                    key.label = key.label.toString().toLowerCase();
                    key.codes[0] = key.codes[0] + 32;
                } else if (key.codes[0] >= 97 && key.codes[0] <= 122) {//小写字母
                    key.label = key.label.toString().toUpperCase();
                    key.codes[0] = key.codes[0] - 32;
                }
            } else if (key.codes[0] == -1) {
                if (isUpper) {
                    key.icon = ContextCompat.getDrawable(mContext, R.drawable.icon_keyboard_capital_selected);
                } else {
                    key.icon = ContextCompat.getDrawable(mContext, R.drawable.icon_keyboard_capital_default);
                }
            }
        }
        keyboardView.invalidateAllKeys();
    }

    /**
     * 判断是否是字母
     */
    private boolean isLetter(String str) {
        String wordStr = "abcdefghijklmnopqrstuvwxyz";
        return wordStr.contains(str.toLowerCase());
    }

    private void hideKeyboard() {
        Log.d(TAG, "hideKeyboard: ");
        if (mDialog != null && mDialog.isShowing()) {
            mDialog.dismiss();
        }
    }

    /**
     * 显示键盘
     *
     * @param editText
     */
    public Dialog showKeyboard(final EditText editText, final WeakReference<KeyBoardCallback> callback, KeyBoardInputType inputType) {
        this.mEditText = editText;
        this.inputType = inputType;
        switch (inputType) {
            case INPUT_TYPE_NUM_FINISH:
            case INPUT_TYPE_NUM_POINT:
            case INPUT_TYPE_NUM_X:
                updateKeyBoard();
                changeKeyboardState(2);
                break;
            default:
                changeKeyboardState(0);
                break;
        }
        mDialog.setOnDismissListener(new DialogInterface.OnDismissListener() {

            @Override
            public void onDismiss(DialogInterface dialog) {
                editText.clearFocus();
                if (callback != null && callback.get() != null) {
                    callback.get().onKeyBoardShow();
                }
            }
        });
        mDialog.show();
        return mDialog;
    }

    /**
     * 调整键盘某些键
     */
    private void updateKeyBoard() {
        Keyboard.Key shiftKey = null;
        for (Keyboard.Key key : mNumberKeyboard.getKeys()) {
            if (key.codes[0] == Keyboard.KEYCODE_MODE_CHANGE) {
                shiftKey = key;
                break;
            }
        }
        if (shiftKey != null) {
            switch (inputType) {
                case INPUT_TYPE_NUM_FINISH:
                    shiftKey.label = "完成";
                    shiftKey.codes[0] = Keyboard.KEYCODE_DONE;
                    break;
                case INPUT_TYPE_NUM_POINT:
                    shiftKey.label = ".";
                    shiftKey.codes[0] = '.';
                    break;
                case INPUT_TYPE_NUM_X:
                    shiftKey.label = "X";
                    shiftKey.codes[0] = 'X';
                    break;
            }
        }
    }
}