package top.carlwu.simple_keyboard;

import android.app.Activity;
import android.app.Dialog;
import android.text.InputType;
import android.view.MotionEvent;
import android.view.View;
import android.view.WindowManager;
import android.widget.EditText;

import java.lang.ref.WeakReference;
import java.lang.reflect.Method;

public class KeyBoardDialogUtils {
    private static WeakReference<Dialog> mDialogWeakReference;
    private static WeakReference<KeyBoardCallback> mKeyBoardCallback;

    // 隐藏系统键盘
    private static void hideSoftInputMethod(Activity activity, EditText ed) {
        activity.getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_ALWAYS_HIDDEN);
        int currentVersion = android.os.Build.VERSION.SDK_INT;
        String methodName = null;
        if (currentVersion >= 16) {
            // 4.2
            methodName = "setShowSoftInputOnFocus";
        } else if (currentVersion >= 14) {
            // 4.0
            methodName = "setSoftInputShownOnFocus";
        }

        if (methodName == null) {
            ed.setInputType(InputType.TYPE_NULL);
        } else {
            Class<EditText> cls = EditText.class;
            Method setShowSoftInputOnFocus;
            try {
                setShowSoftInputOnFocus = cls.getMethod(methodName, boolean.class);
                setShowSoftInputOnFocus.setAccessible(true);
                setShowSoftInputOnFocus.invoke(ed, false);
            } catch (Exception e) {
                e.printStackTrace();
                ed.setInputType(InputType.TYPE_NULL);
            }
        }
    }

    private static Dialog show(Activity activity, final EditText editText,WeakReference<KeyBoardCallback> callback, KeyBoardInputType inputType) {
        hideSoftInputMethod(activity, editText);
        editText.setFocusable(true);
        editText.setFocusableInTouchMode(true);
        editText.requestFocus();
        editText.setCursorVisible(true);
        editText.setSelection(editText.getText().toString().length());

        KhKeyboardView keyboardView = new KhKeyboardView(activity);
        return keyboardView.showKeyboard(editText, callback,inputType);
    }

    public static void registerCustomInputMethod(final Activity activity, final EditText editText, KeyBoardCallback callback) {
        registerCustomInputMethod(activity, editText, callback, KeyBoardInputType.INPUT_TYPE_DEFAULT);
    }

    public static void registerCustomInputMethod(final Activity activity, final EditText editText, final KeyBoardCallback callback, final KeyBoardInputType inputType) {
        mKeyBoardCallback = new WeakReference<KeyBoardCallback>(callback);
        editText.setOnTouchListener(new View.OnTouchListener() {
            @Override
            public boolean onTouch(View v, MotionEvent event) {
                if (event.getAction() == MotionEvent.ACTION_UP) {
                    Dialog dialog = show(activity, editText, mKeyBoardCallback,inputType);
                    mDialogWeakReference = new WeakReference<Dialog>(dialog);
                    if (mKeyBoardCallback != null && mKeyBoardCallback.get() != null) {
                        mKeyBoardCallback.get().onKeyBoardShow();
                    }
                }
                return false;
            }
        });
    }

    public static void dissmissInputDialog() {
        if (mDialogWeakReference != null) {
            Dialog dialog = mDialogWeakReference.get();
            if (dialog != null && dialog.isShowing()) {
                dialog.dismiss();
                if (mKeyBoardCallback != null && mKeyBoardCallback.get() != null) {
                    mKeyBoardCallback.get().onKeyBoardShow();
                }
            }
        }
    }
}









