package top.carlwu.adb_wifi;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import android.util.Log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

/**
 * Created by wuyoujin on 2017/11/7/007.
 */

public final class AdbWifiUtil {
    private static final String TAG = "adb_wifi_lib_util";

    /**
     * 开启5555端口调试
     */
    @SuppressLint("MissingPermission")
    public static String enableAdbWifi(Context context) {
        try {
            if (!TextUtils.equals(getPort(), "5555")) {
                String cmd = "setprop service.adb.tcp.port 5555";
                String[] cmds = {"su", cmd, "stop adbd", "start adbd"};
                for (String c : cmds) {
                    Runtime.getRuntime().exec(c);
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
        String s = getIP(context) + ":5555";
        Log.i(TAG, "enableAdbWifi: " + s);
        return s;
    }

    @SuppressLint("MissingPermission")
    private static String getIP(Context context) {
        WifiManager wifiManager = (WifiManager) context.getApplicationContext().getSystemService(Context.WIFI_SERVICE);
        WifiInfo wifiInfo = wifiManager.getConnectionInfo();
        int IP = wifiInfo == null ? 0 : wifiInfo.getIpAddress();
        int mask = 0xff;
        return String.format("%s.%s.%s.%s",
                IP & mask, IP >> 8 & mask, IP >> 16 & mask, IP >> 24 & mask);
    }

    private static String getPort() throws IOException {
        String cmd = "getprop service.adb.tcp.port";
        String port = "-1";
        Runtime.getRuntime().exec("su");
        Process proc = Runtime.getRuntime().exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        port = in.readLine();
        return port;
    }
}
