/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.address;

import nectec.thai.address.AddressEntity;
import nectec.thai.address.InvalidAddressCodeFormatException;
import nectec.thai.address.Region;
import nectec.util.TextUtils;

public class Province
implements AddressEntity,
Comparable<Province> {
    private final String code;
    private final String name;
    private final Region region;

    public Province(String code, String name, Region region) {
        if (code.length() != 2 || !TextUtils.isDigitOnly(code)) {
            throw new InvalidAddressCodeFormatException.InvalidProvinceCodeException(code);
        }
        this.code = code;
        this.name = name;
        this.region = region;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Region getRegion() {
        return this.region;
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.region.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Province otherProvince = (Province)other;
        return this.code.equals(otherProvince.code) && this.name.equals(otherProvince.name) && this.region == otherProvince.region;
    }

    public String toString() {
        return "Province{code='" + this.code + '\'' + ", name='" + this.name + '\'' + ", region=" + (Object)((Object)this.region) + '}';
    }

    @Override
    public int compareTo(Province that) {
        return this.name.compareTo(that.name);
    }
}

