/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.identity;

import android.text.Editable;
import android.text.InputFilter;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.widget.EditText;
import nectec.thai.identity.Identity;
import nectec.thai.widget.identity.IdentityWatcher;

public abstract class IdentityHandler<T extends Identity> {
    private EditText editText;
    private boolean watching = true;
    private T id;
    private IdentityWatcher<T> idWatcher;

    public IdentityHandler(EditText editText) {
        this.editText = editText;
        this.id = this.onCreateNewId(editText.getText().toString());
        editText.setInputType(2);
        editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.getMaxLength())});
        editText.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)false, (boolean)true));
        editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                if (IdentityHandler.this.watching) {
                    IdentityHandler.this.onIdChanged(editable);
                }
            }
        });
    }

    protected abstract int getMaxLength();

    protected abstract T onCreateNewId(String var1);

    private void onIdChanged(Editable editable) {
        T id2 = this.onCreateNewId(editable.toString());
        this.updateText(id2);
    }

    private void updateText(T id2) {
        String newText = id2.prettyPrint();
        Editable currentText = this.editText.getText();
        if (newText.length() > currentText.length() && newText.length() <= this.getMaxLength()) {
            this.watching = false;
            this.id = id2;
            this.editText.setText((CharSequence)newText);
            this.editText.setSelection(this.editText.getText().length());
            this.watching = true;
        }
        if (newText.length() == this.getMaxLength()) {
            this.validate(id2);
        }
    }

    private void validate(T id2) {
        if (id2.validate()) {
            if (this.idWatcher != null) {
                this.idWatcher.onValid(id2);
            }
        } else if (this.idWatcher != null) {
            this.idWatcher.onInvalid(id2);
        }
    }

    public T getId() {
        return this.id;
    }

    public void setIdWatcher(IdentityWatcher idWatcher) {
        this.idWatcher = idWatcher;
    }
}

