/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.identity;

import android.content.Context;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import nectec.thai.identity.Identity;
import nectec.thai.widget.identity.IdentityHandler;
import nectec.thai.widget.identity.IdentityWatcher;

public class IdentityEditText<T extends Identity>
extends AppCompatEditText {
    private IdentityHandler<T> idHandler;
    private IdentityWatcher<T> onInvalid;

    public IdentityEditText(Context context) {
        this(context, null);
    }

    public IdentityEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842862);
    }

    public IdentityEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    void init(IdentityHandler<T> handler, final String defaultErrMessage) {
        this.idHandler = handler;
        this.onInvalid = new IdentityWatcher<T>(){

            @Override
            public void onInvalid(T identity) {
                IdentityEditText.this.setError(defaultErrMessage);
            }

            @Override
            public void onValid(T identity) {
                IdentityEditText.this.setError(null);
            }
        };
        this.idHandler.setIdWatcher(this.onInvalid);
    }

    public void setOnInvalid(IdentityWatcher<T> onInvalid) {
        this.onInvalid = onInvalid;
        this.idHandler.setIdWatcher(onInvalid);
    }

    public Identity getIdentity() {
        return this.idHandler.getId();
    }

    public boolean isValid() {
        return this.idHandler.getId().validate();
    }
}

