/*
 * Decompiled with CFR 0.152.
 */
package nectec.thai.widget.address.repository;

import android.content.Context;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nectec.thai.address.AddressRepository;
import nectec.thai.address.District;
import nectec.thai.address.InvalidAddressCodeFormatException;
import nectec.thai.widget.address.repository.JsonParser;

public final class DistrictRepository
implements AddressRepository<District> {
    private static DistrictRepository instance;
    private final List<District> allDistrict;

    private DistrictRepository(Context context) {
        this.allDistrict = JsonParser.parse(context, "district.json", District.class);
        Collections.sort(this.allDistrict);
    }

    public static DistrictRepository getInstance(Context context) {
        if (instance == null) {
            instance = new DistrictRepository(context);
        }
        return instance;
    }

    @Override
    public List<District> find() {
        return this.allDistrict;
    }

    @Override
    public List<District> findByParentCode(String provinceCode) {
        if (provinceCode.length() != 2) {
            throw new InvalidAddressCodeFormatException.InvalidProvinceCodeException(provinceCode);
        }
        ArrayList<District> queryDistrict = new ArrayList<District>();
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(provinceCode)) continue;
            queryDistrict.add(eachDistrict);
        }
        return queryDistrict.isEmpty() ? null : queryDistrict;
    }

    @Override
    public District findByCode(String districtCode) {
        if (districtCode.length() != 4) {
            throw new InvalidAddressCodeFormatException.InvalidDistrictCodeException(districtCode);
        }
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(districtCode)) continue;
            return eachDistrict;
        }
        return null;
    }
}

