/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.unit;

import android.annotation.SuppressLint;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.NumberPicker;
import th.or.nectec.thai.unit.Area;
import th.or.nectec.thai.widget.thai.R;
import th.or.nectec.thai.widget.unit.AreaPicker;

public class AreaPickerDialog
extends AlertDialog
implements AreaPicker.AreaPopup {
    public static final String TITLE = "\u0e23\u0e30\u0e1a\u0e38\u0e02\u0e19\u0e32\u0e14\u0e1e\u0e37\u0e49\u0e19\u0e17\u0e35\u0e48";
    public static final String TITLE_SEPARATOR = " - ";
    private NumberPicker rai;
    private NumberPicker ngan;
    private NumberPicker squareWa;
    private OnAreaPickListener onAreaPickListener;
    private DialogInterface.OnClickListener onPositiveButtonClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialogInterface, int i) {
            Area area = Area.fromRaiNganSqaureWa((int)AreaPickerDialog.this.rai.getValue(), (int)AreaPickerDialog.this.ngan.getValue(), (int)AreaPickerDialog.this.squareWa.getValue());
            AreaPickerDialog.this.onAreaPickListener.onAreaPick(area);
            AreaPickerDialog.this.dismiss();
        }
    };
    private DialogInterface.OnClickListener onNegativeButtonClick = new DialogInterface.OnClickListener(){

        public void onClick(DialogInterface dialogInterface, int i) {
            AreaPickerDialog.this.onAreaPickListener.onCancel();
            AreaPickerDialog.this.dismiss();
        }
    };
    private NumberPicker.OnValueChangeListener raiNganSquareWaChangeListener = new NumberPicker.OnValueChangeListener(){

        public void onValueChange(NumberPicker numberPicker, int i, int i1) {
            Area area = Area.fromRaiNganSqaureWa((int)AreaPickerDialog.this.rai.getValue(), (int)AreaPickerDialog.this.ngan.getValue(), (int)AreaPickerDialog.this.squareWa.getValue());
            AreaPickerDialog.this.updateTitle(area);
        }
    };

    public AreaPickerDialog(Context context, OnAreaPickListener listener) {
        super(context);
        this.onAreaPickListener = listener;
        this.setTitle(TITLE);
        this.setupView(context);
    }

    private void setupView(Context context) {
        View view = this.InflateView(context);
        this.setView(view);
        this.findView(view);
        this.initRai();
        this.initNgan();
        this.initSquareWa();
        this.initButton();
    }

    @SuppressLint(value={"InflateParams"})
    private View InflateView(Context context) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        return inflater.inflate(R.layout.dialog_area_picker, null, false);
    }

    private void findView(View view) {
        this.rai = (NumberPicker)view.findViewById(R.id.rai);
        this.ngan = (NumberPicker)view.findViewById(R.id.ngan);
        this.squareWa = (NumberPicker)view.findViewById(R.id.squareWa);
    }

    private void initSquareWa() {
        this.squareWa.setMaxValue(99);
        this.squareWa.setMinValue(0);
        this.squareWa.setValue(0);
        this.squareWa.setOnValueChangedListener(this.raiNganSquareWaChangeListener);
    }

    private void initNgan() {
        this.ngan.setMaxValue(3);
        this.ngan.setMinValue(0);
        this.ngan.setValue(0);
        this.ngan.setOnValueChangedListener(this.raiNganSquareWaChangeListener);
    }

    private void initRai() {
        this.rai.setMaxValue(10000);
        this.rai.setMinValue(0);
        this.rai.setValue(0);
        this.rai.setOnValueChangedListener(this.raiNganSquareWaChangeListener);
    }

    private void initButton() {
        this.setButton(-1, "ok", this.onPositiveButtonClick);
        this.setButton(-2, "cancel", this.onNegativeButtonClick);
    }

    @Override
    public void show(Area area) {
        this.updateValue(area);
        this.show();
    }

    private void updateValue(Area area) {
        this.rai.setValue(area.getRai());
        this.ngan.setValue(area.getNgan());
        this.squareWa.setValue(area.getSquareWa());
    }

    private void updateTitle(Area area) {
        StringBuilder builder = new StringBuilder(TITLE);
        String detail = area.prettyPrint();
        if (!TextUtils.isEmpty((CharSequence)detail)) {
            builder.append(TITLE_SEPARATOR).append(detail);
        }
        this.setTitle(builder);
    }

    public static interface OnAreaPickListener {
        public void onAreaPick(Area var1);

        public void onCancel();
    }
}

