/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.address;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.thai.address.AddressEntity;
import th.or.nectec.thai.widget.R;

class AddressListAdapter<T extends AddressEntity>
extends BaseAdapter {
    private final LayoutInflater mInflater;
    private final Context context;
    private List<T> addressList;

    public AddressListAdapter(Context context, List<T> addressList) {
        this.context = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.addAll(addressList);
    }

    public final void addAll(List<T> collection) {
        this.addressList = new ArrayList<T>();
        this.addressList.addAll(collection);
        this.notifyDataSetChanged();
    }

    public View getDropDownView(int position, View convertView, ViewGroup parent) {
        return this.getView(position, convertView, parent);
    }

    public int getCount() {
        return this.addressList.size();
    }

    public T getItem(int position) {
        return (T)((AddressEntity)this.addressList.get(position));
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (convertView == null) {
            convertView = this.mInflater.inflate(R.layout.list_item_address, parent, false);
            convertView.setTag((Object)new ViewHolder(convertView));
        }
        T entity = this.getItem(position);
        ViewHolder viewHolder = (ViewHolder)convertView.getTag();
        viewHolder.name.setText((CharSequence)entity.getName());
        viewHolder.code.setText((CharSequence)this.context.getString(R.string.address_code_format, new Object[]{entity.getCode()}));
        return convertView;
    }

    private class ViewHolder {
        protected TextView name;
        protected TextView code;

        public ViewHolder(View view) {
            this.name = (TextView)view.findViewById(R.id.name);
            this.code = (TextView)view.findViewById(R.id.code);
            this.code.setVisibility(8);
        }
    }
}

