/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.identity;

import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.text.method.DigitsKeyListener;
import android.text.method.KeyListener;
import android.widget.EditText;
import th.or.nectec.thai.identity.Identity;

public abstract class IdentityEditTextHandler
implements TextWatcher {
    protected EditText editText;
    private Identity id;

    public IdentityEditTextHandler(EditText editText) {
        this.editText = editText;
        this.id = this.onCreateNewId(editText.getText().toString());
        this.initialize();
    }

    protected void initialize() {
        this.editText.setInputType(2);
        this.editText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.getMaxLength())});
        this.editText.setKeyListener((KeyListener)DigitsKeyListener.getInstance((boolean)false, (boolean)true));
        this.editText.addTextChangedListener((TextWatcher)this);
    }

    protected abstract int getMaxLength();

    protected abstract Identity onCreateNewId(String var1);

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void afterTextChanged(Editable editable) {
        this.onIdChanged(editable);
    }

    public void onIdChanged(Editable editable) {
        Identity id2 = this.onCreateNewId(editable.toString());
        this.updateText(id2);
        this.updateErrorMessage(id2);
    }

    private void updateText(Identity id2) {
        if (!id2.equals(this.id)) {
            this.id = id2;
            this.editText.setText((CharSequence)id2.prettyPrint());
            Selection.setSelection((Spannable)this.editText.getEditableText(), (int)this.editText.length());
        }
    }

    private void updateErrorMessage(Identity id2) {
        if (id2.isValidFormat()) {
            this.editText.setError((CharSequence)(id2.validate() ? null : this.getErrorMessage()));
        } else {
            this.editText.setError(null);
        }
    }

    protected abstract String getErrorMessage();

    public Identity getId() {
        return this.id;
    }
}

