/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.utils;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JsonParser {
    private static final String ENCODING_UTF_8 = "UTF-8";

    public static <T> List<T> list(Context context, String jsonFileName, Type typeOfT) {
        ArrayList<Object> list = new ArrayList<Object>();
        Gson gson = new Gson();
        try {
            InputStream inputStream = context.getAssets().open(jsonFileName);
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, ENCODING_UTF_8));
            reader.beginArray();
            while (reader.hasNext()) {
                Object item = gson.fromJson(reader, typeOfT);
                list.add(item);
            }
            reader.endArray();
            reader.close();
        }
        catch (IOException e) {
            throw new JsonParserException(e);
        }
        return list;
    }

    public static class JsonParserException
    extends RuntimeException {
        public JsonParserException(IOException ioException) {
            super(ioException);
        }
    }
}

