/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.app.Dialog;
import android.app.DialogFragment;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.android.widget.thai.OnAddressChangedListener;
import th.or.nectec.android.widget.thai.R;
import th.or.nectec.android.widget.thai.address.AddressAdapter;
import th.or.nectec.android.widget.thai.address.EnumRegionRepository;
import th.or.nectec.android.widget.thai.address.InMemoryJsonDistrictRepository;
import th.or.nectec.android.widget.thai.address.InMemoryJsonProvinceRepository;
import th.or.nectec.android.widget.thai.address.InMemoryJsonSubdistrictRepository;
import th.or.nectec.domain.thai.address.AddressController;
import th.or.nectec.domain.thai.address.AddressPresenter;
import th.or.nectec.domain.thai.address.DistrictChooser;
import th.or.nectec.domain.thai.address.DistrictPresenter;
import th.or.nectec.domain.thai.address.DistrictRepository;
import th.or.nectec.domain.thai.address.ProvinceChooser;
import th.or.nectec.domain.thai.address.ProvincePresenter;
import th.or.nectec.domain.thai.address.ProvinceRepository;
import th.or.nectec.domain.thai.address.RegionChooser;
import th.or.nectec.domain.thai.address.RegionPresenter;
import th.or.nectec.domain.thai.address.RegionRepository;
import th.or.nectec.domain.thai.address.SubdistrictChooser;
import th.or.nectec.domain.thai.address.SubdistrictListPresenter;
import th.or.nectec.domain.thai.address.SubdistrictRepository;
import th.or.nectec.entity.thai.Address;
import th.or.nectec.entity.thai.District;
import th.or.nectec.entity.thai.Province;
import th.or.nectec.entity.thai.Region;
import th.or.nectec.entity.thai.Subdistrict;

public class AddressPickerDialogFragment
extends DialogFragment
implements AdapterView.OnItemClickListener,
RegionPresenter,
ProvincePresenter,
DistrictPresenter,
SubdistrictListPresenter,
AddressPresenter {
    public static final String FRAGMENT_TAG = "address_dialog";
    private static final int SELECT_REGION = 0;
    private static final int SELECT_PROVINCE = 1;
    private static final int SELECT_DISTRICT = 2;
    private static final int SELECT_SUBDISTRICT = 3;
    private OnAddressChangedListener addressChangedListener;
    private ListView listView;
    private ArrayAdapter<String> regionAdapter;
    private RegionChooser regionChooser = new RegionChooser((RegionRepository)new EnumRegionRepository(), (RegionPresenter)this);
    private AddressAdapter<District> districtAdapter;
    private DistrictChooser districtChooser;
    private AddressAdapter<Province> provinceAdapter;
    private ProvinceChooser provinceChooser;
    private AddressAdapter<Subdistrict> subdistrictAdapter;
    private SubdistrictChooser subdistrictChooser;
    private InMemoryJsonProvinceRepository inMemoryJsonProvinceRepository;
    private InMemoryJsonDistrictRepository inMemoryJsonDistrictRepository;
    private InMemoryJsonSubdistrictRepository inMemoryJsonSubdistrictRepository;
    private Subdistrict subdistrictData;
    private District districtData;
    private Province provinceData;
    private int currentState = 0;
    private TextView titleView;
    private TextView statusInfoView;
    private String regionString;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_address_list_picker, container, false);
        this.initInstances(view);
        return view;
    }

    private void initInstances(View view) {
        this.titleView = (TextView)view.findViewById(R.id.title_text);
        this.statusInfoView = (TextView)view.findViewById(R.id.status_info);
        this.listView = (ListView)view.findViewById(R.id.picker_list);
        this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.setupRepository();
        this.bringToRegionList();
    }

    private void setupRepository() {
        this.inMemoryJsonProvinceRepository = InMemoryJsonProvinceRepository.getInstance((Context)this.getActivity());
        this.inMemoryJsonDistrictRepository = InMemoryJsonDistrictRepository.getInstance((Context)this.getActivity());
        this.inMemoryJsonSubdistrictRepository = InMemoryJsonSubdistrictRepository.getInstance((Context)this.getActivity());
    }

    private void bringToRegionList() {
        this.titleView.setVisibility(8);
        this.statusInfoView.setText(R.string.choose_region);
        this.regionChooser.showRegionList();
        this.listView.setAdapter(this.regionAdapter);
        this.currentState = 0;
    }

    public void showRegionList(List<Region> regions) {
        List<String> regionStringList = this.mapToListOfString(regions);
        this.regionAdapter = new ArrayAdapter((Context)this.getActivity(), R.layout.address_picker_list_item, regionStringList);
    }

    public void showNotFoundRegion() {
        Toast.makeText((Context)this.getActivity(), (int)R.string.region_not_found, (int)1).show();
    }

    public List<String> mapToListOfString(List<Region> regions) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Region region : regions) {
            stringList.add(region.toString());
        }
        return stringList;
    }

    public void showProvinceList(List<Province> provinces) {
        this.provinceAdapter = new AddressAdapter((Context)this.getActivity(), provinces);
    }

    public void showNotFoundProvince() {
        Toast.makeText((Context)this.getActivity(), (int)R.string.province_not_found, (int)1).show();
    }

    public void showDistrictList(List<District> districts) {
        this.districtAdapter = new AddressAdapter((Context)this.getActivity(), districts);
    }

    public void showNotFoundDistrict() {
        Toast.makeText((Context)this.getActivity(), (int)R.string.district_not_found, (int)1).show();
    }

    public void showSubdistrictList(List<Subdistrict> subdistricts) {
        this.subdistrictAdapter = new AddressAdapter((Context)this.getActivity(), subdistricts);
    }

    public void showNotFoundSubdistrict() {
        Toast.makeText((Context)this.getActivity(), (int)R.string.subdistrict_not_found, (int)1).show();
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long l) {
        if (this.currentState == 0) {
            this.regionString = (String)this.regionAdapter.getItem(position);
            this.bringToProvinceList(this.regionString);
        } else if (this.currentState == 1) {
            this.provinceData = (Province)this.provinceAdapter.getItem(position);
            this.bringToDistrictList(this.provinceData.getCode());
        } else if (this.currentState == 2) {
            this.districtData = (District)this.districtAdapter.getItem(position);
            this.bringToSubdistrictList(this.districtData.getCode());
        } else if (this.currentState == 3) {
            this.subdistrictData = (Subdistrict)this.subdistrictAdapter.getItem(position);
            AddressController addressController = new AddressController((SubdistrictRepository)this.inMemoryJsonSubdistrictRepository, (DistrictRepository)this.inMemoryJsonDistrictRepository, (ProvinceRepository)this.inMemoryJsonProvinceRepository, (AddressPresenter)this);
            addressController.showByAddressCode(this.subdistrictData.getCode());
        }
    }

    private void bringToProvinceList(String region) {
        this.titleView.setText((CharSequence)this.regionString);
        this.statusInfoView.setText(R.string.choose_province);
        this.titleView.setVisibility(0);
        this.provinceChooser = new ProvinceChooser((ProvinceRepository)this.inMemoryJsonProvinceRepository, (ProvincePresenter)this);
        this.provinceChooser.showProvinceListByRegion(Region.fromName((String)region));
        this.listView.setAdapter(this.provinceAdapter);
        this.currentState = 1;
    }

    private void bringToDistrictList(String provinceCode) {
        this.titleView.setText((CharSequence)this.regionString.concat(" > ").concat(this.provinceData.getName()));
        this.statusInfoView.setText(R.string.choose_district);
        this.titleView.setVisibility(0);
        this.districtChooser = new DistrictChooser((DistrictRepository)this.inMemoryJsonDistrictRepository, (DistrictPresenter)this);
        this.districtChooser.showDistrictListByProvinceCode(provinceCode);
        this.listView.setAdapter(this.districtAdapter);
        this.currentState = 2;
    }

    private void bringToSubdistrictList(String districtCode) {
        this.titleView.setText((CharSequence)String.format(this.getString(R.string.breadcrumb_text), this.provinceData.getName(), this.districtData.getName()));
        this.statusInfoView.setText(R.string.choose_subdistrict);
        this.titleView.setVisibility(0);
        this.subdistrictChooser = new SubdistrictChooser((SubdistrictRepository)this.inMemoryJsonSubdistrictRepository, (SubdistrictListPresenter)this);
        this.subdistrictChooser.showSubdistrictListByDistrictCode(districtCode);
        this.listView.setAdapter(this.subdistrictAdapter);
        this.currentState = 3;
    }

    public void setOnAddressChangedListener(OnAddressChangedListener addressChangedListener) {
        this.addressChangedListener = addressChangedListener;
    }

    public void restoreAddressField(final Address address) {
        new Handler().post(new Runnable(){

            @Override
            public void run() {
                AddressPickerDialogFragment.this.regionString = address.getRegion().toString();
                AddressPickerDialogFragment.this.provinceData = address.getProvince();
                AddressPickerDialogFragment.this.subdistrictData = address.getSubdistrict();
                AddressPickerDialogFragment.this.districtData = address.getDistrict();
                AddressPickerDialogFragment.this.bringToSubdistrictList(address.getDistrictCode());
            }
        });
    }

    public void displayAddressInfo(Address address) {
        this.bringAddressValueToAddressView(address);
    }

    private void bringAddressValueToAddressView(Address addressData) {
        if (this.addressChangedListener != null) {
            this.addressChangedListener.onAddressChanged(addressData);
        }
        this.dismiss();
    }

    public void alertAddressNotFound() {
        Toast.makeText((Context)this.getActivity(), (int)R.string.address_not_found, (int)1).show();
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = new Dialog((Context)this.getActivity(), this.getTheme()){

            public void onBackPressed() {
                if (AddressPickerDialogFragment.this.currentState == 0) {
                    if (AddressPickerDialogFragment.this.addressChangedListener != null) {
                        AddressPickerDialogFragment.this.addressChangedListener.onAddressCanceled();
                    }
                    this.dismiss();
                } else if (AddressPickerDialogFragment.this.currentState == 1) {
                    AddressPickerDialogFragment.this.bringToRegionList();
                } else if (AddressPickerDialogFragment.this.currentState == 2) {
                    AddressPickerDialogFragment.this.bringToProvinceList(AddressPickerDialogFragment.this.provinceData.getRegion().toString());
                } else if (AddressPickerDialogFragment.this.currentState == 3) {
                    AddressPickerDialogFragment.this.bringToDistrictList(AddressPickerDialogFragment.this.districtData.getProvinceCode());
                }
            }
        };
        dialog.getWindow().requestFeature(1);
        return dialog;
    }
}

