/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.List;
import java.util.Stack;
import th.or.nectec.android.widget.thai.OnAddressChangedListener;
import th.or.nectec.android.widget.thai.R;
import th.or.nectec.android.widget.thai.address.AddressAdapter;
import th.or.nectec.android.widget.thai.address.AddressPopup;
import th.or.nectec.android.widget.thai.address.InMemoryJsonDistrictRepository;
import th.or.nectec.android.widget.thai.address.InMemoryJsonProvinceRepository;
import th.or.nectec.android.widget.thai.address.InMemoryJsonSubdistrictRepository;
import th.or.nectec.domain.thai.address.AddressController;
import th.or.nectec.domain.thai.address.AddressPresenter;
import th.or.nectec.domain.thai.address.DistrictRepository;
import th.or.nectec.domain.thai.address.ProvinceRepository;
import th.or.nectec.domain.thai.address.SubdistrictRepository;
import th.or.nectec.entity.thai.Address;
import th.or.nectec.entity.thai.AddressEntity;
import th.or.nectec.entity.thai.District;
import th.or.nectec.entity.thai.Province;
import th.or.nectec.entity.thai.Subdistrict;

public class AddressPickerDialog
extends Dialog
implements AddressPopup,
AdapterView.OnItemClickListener {
    Stack<AddressEntity> addressStack = new Stack();
    private TextView statusInfoView;
    private TextView titleView;
    private ListView listView;
    private ProvinceRepository provinceRepository;
    private DistrictRepository districtRepository;
    private SubdistrictRepository subdistrictRepository;
    private OnAddressChangedListener onAddressChangedListener;
    private AddressAdapter addressAdapter;

    public AddressPickerDialog(Context context, OnAddressChangedListener onAddressChangedListener) {
        this(context, 0, onAddressChangedListener);
    }

    public AddressPickerDialog(Context context, int themeResId, OnAddressChangedListener onAddressChangedListener) {
        super(context, themeResId);
        this.requestWindowFeature(1);
        this.onAddressChangedListener = onAddressChangedListener;
        this.provinceRepository = InMemoryJsonProvinceRepository.getInstance((Context)context);
        this.districtRepository = InMemoryJsonDistrictRepository.getInstance((Context)context);
        this.subdistrictRepository = InMemoryJsonSubdistrictRepository.getInstance((Context)context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setTitle(null);
        this.setContentView(R.layout.fragment_address_list_picker);
        this.titleView = (TextView)this.findViewById(R.id.title_text);
        this.statusInfoView = (TextView)this.findViewById(R.id.status_info);
        this.listView = (ListView)this.findViewById(R.id.picker_list);
        this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.switchPage();
    }

    public void onBackPressed() {
        if (this.addressStack.empty()) {
            this.dismiss();
            this.notifyAddressCancel();
            return;
        }
        this.addressStack.pop();
        this.switchPage();
    }

    private void notifyAddressCancel() {
        this.onAddressChangedListener.onAddressCanceled();
    }

    private void switchPage() {
        if (this.addressStack.empty()) {
            this.showProvinceList();
            return;
        }
        AddressEntity choosedEntity = this.addressStack.peek();
        if (choosedEntity instanceof Province) {
            this.showDistrictList(choosedEntity.getCode());
        } else if (choosedEntity instanceof District) {
            this.showSubDistrictList(choosedEntity.getCode());
        } else if (choosedEntity instanceof Subdistrict) {
            this.notifyAddressChange(choosedEntity.getCode());
            this.dismiss();
        }
    }

    private void showSubDistrictList(String code) {
        this.titleView.setVisibility(0);
        this.titleView.setText((CharSequence)this.makeTitle());
        this.statusInfoView.setText(R.string.choose_subdistrict);
        List subDistricts = this.subdistrictRepository.findByDistrictCode(code);
        this.setListAdapter(new AddressAdapter(this.getContext(), subDistricts));
    }

    private String makeTitle() {
        return this.addressStack.peek().getName();
    }

    private void notifyAddressChange(String code) {
        AddressController controller = new AddressController(this.subdistrictRepository, this.districtRepository, this.provinceRepository, new AddressPresenter(){

            public void displayAddressInfo(Address address) {
                AddressPickerDialog.this.onAddressChangedListener.onAddressChanged(address);
            }

            public void alertAddressNotFound() {
            }
        });
        controller.showByAddressCode(code);
    }

    public void show(Address area) {
        this.addressStack.push((AddressEntity)area.getProvince());
        this.addressStack.push((AddressEntity)area.getDistrict());
        this.show();
    }

    private void showProvinceList() {
        this.titleView.setVisibility(8);
        this.statusInfoView.setText(R.string.choose_province);
        List provinces = this.provinceRepository.find();
        this.setListAdapter(new AddressAdapter(this.getContext(), provinces));
    }

    public void show(String addressCode) {
        Address address = new Address();
        address.setProvince(this.provinceRepository.findByProvinceCode(addressCode.substring(0, 2)));
        address.setDistrict(this.districtRepository.findByDistrictCode(addressCode.substring(0, 4)));
        this.show(address);
    }

    private void setListAdapter(AddressAdapter addressAdapter) {
        this.addressAdapter = addressAdapter;
        this.listView.setAdapter((ListAdapter)addressAdapter);
    }

    public void setOnAddressChangedListener(OnAddressChangedListener onAddressChangedListener) {
        this.onAddressChangedListener = onAddressChangedListener;
    }

    private void showDistrictList(String code) {
        this.titleView.setText((CharSequence)this.addressStack.peek().getName());
        this.titleView.setVisibility(0);
        this.statusInfoView.setText(R.string.choose_district);
        List districts = this.districtRepository.findByProvinceCode(code);
        this.setListAdapter(new AddressAdapter(this.getContext(), districts));
    }

    public AddressPickerDialog setRepository(ProvinceRepository province) {
        this.provinceRepository = province;
        return this;
    }

    public AddressPickerDialog setRepository(DistrictRepository districtRepository) {
        this.districtRepository = districtRepository;
        return this;
    }

    public AddressPickerDialog setRepository(SubdistrictRepository subdistrictRepository) {
        this.subdistrictRepository = subdistrictRepository;
        return this;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        AddressEntity choosedEntity = this.addressAdapter.getItem(position);
        this.addressStack.push(choosedEntity);
        this.switchPage();
    }
}

