/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.address;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.util.Iterator;
import java.util.List;
import th.or.nectec.thai.address.Address;
import th.or.nectec.thai.address.AddressEntity;
import th.or.nectec.thai.address.AddressRepository;
import th.or.nectec.thai.address.District;
import th.or.nectec.thai.address.Province;
import th.or.nectec.thai.address.SubDistrict;
import th.or.nectec.thai.widget.R;
import th.or.nectec.thai.widget.address.AddressListAdapter;
import th.or.nectec.thai.widget.address.AddressPopup;
import th.or.nectec.thai.widget.address.AddressView;
import th.or.nectec.thai.widget.address.ArrayStack;
import th.or.nectec.thai.widget.address.repository.AddressRepositoryImpl;
import th.or.nectec.thai.widget.address.repository.DistrictRepository;
import th.or.nectec.thai.widget.address.repository.ProvinceRepository;
import th.or.nectec.thai.widget.address.repository.SubDistrictRepository;

public class AddressPickerDialog
extends Dialog
implements AddressPopup,
AdapterView.OnItemClickListener {
    private ArrayStack<AddressEntity> addressStack = new ArrayStack();
    private TextView header;
    private TextView breadcrumb;
    private ListView list;
    private AddressRepositoryImpl addressRepository;
    private AddressRepository<Province> provinceRepository;
    private AddressRepository<District> districtRepository;
    private AddressRepository<SubDistrict> subDistrictRepository;
    private AddressView.OnAddressChangedListener onAddressChangedListener;
    private AddressListAdapter addressListAdapter;

    public AddressPickerDialog(Context context) {
        this(context, null);
    }

    public AddressPickerDialog(Context context, AddressView.OnAddressChangedListener onAddressChangedListener) {
        this(context, 0, onAddressChangedListener);
    }

    public AddressPickerDialog(Context context, int themeResId, AddressView.OnAddressChangedListener onAddressChangedListener) {
        super(context, themeResId);
        this.requestWindowFeature(1);
        this.setOnAddressChangedListener(onAddressChangedListener);
        this.addressRepository = AddressRepositoryImpl.getInstance(context);
        this.provinceRepository = ProvinceRepository.getInstance(context);
        this.districtRepository = DistrictRepository.getInstance(context);
        this.subDistrictRepository = SubDistrictRepository.getInstance(context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_address_picker);
        this.breadcrumb = (TextView)this.findViewById(R.id.breadcrumb);
        this.header = (TextView)this.findViewById(R.id.header);
        this.list = (ListView)this.findViewById(R.id.picker_list);
        this.list.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.findViewById(R.id.back).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                AddressPickerDialog.this.onBackPressed();
            }
        });
        this.switchPage();
    }

    public void onBackPressed() {
        if (this.addressStack.isEmpty()) {
            this.onAddressChangedListener.onAddressCanceled();
            this.dismiss();
            return;
        }
        this.addressStack.pop();
        this.switchPage();
    }

    public AddressPickerDialog setProvinceRepository(AddressRepository<Province> province) {
        this.provinceRepository = province;
        return this;
    }

    public AddressPickerDialog setDistrictRepository(AddressRepository<District> districtRepository) {
        this.districtRepository = districtRepository;
        return this;
    }

    public AddressPickerDialog setSubDistrictRepository(AddressRepository<SubDistrict> subDistrictRepository) {
        this.subDistrictRepository = subDistrictRepository;
        return this;
    }

    public void onItemClick(AdapterView<?> adapterView, View view, int position, long id2) {
        this.addressStack.push((AddressEntity)this.addressListAdapter.getItem(position));
        this.switchPage();
    }

    private void switchPage() {
        this.updateBreadCrumb();
        if (this.addressStack.isEmpty()) {
            this.updateDialog(R.string.choose_province, this.provinceRepository.find());
            return;
        }
        AddressEntity choosedEntity = this.addressStack.peek();
        if (choosedEntity instanceof Province) {
            this.updateDialog(R.string.choose_district, this.districtRepository.findByParentCode(choosedEntity.getCode()));
        } else if (choosedEntity instanceof District) {
            this.updateDialog(R.string.choose_subdistrict, this.subDistrictRepository.findByParentCode(choosedEntity.getCode()));
        } else if (choosedEntity instanceof SubDistrict) {
            this.notifyAddressChange(choosedEntity.getCode());
            this.dismiss();
        }
    }

    private void updateBreadCrumb() {
        if (this.addressStack.isEmpty()) {
            this.breadcrumb.setText((CharSequence)"");
            this.breadcrumb.setVisibility(8);
            return;
        }
        StringBuilder builder = new StringBuilder();
        Iterator<AddressEntity> iterator = this.addressStack.getIterator();
        while (iterator.hasNext()) {
            builder.append(iterator.next().getName());
            if (!iterator.hasNext()) continue;
            builder.append("  >  ");
        }
        this.breadcrumb.setText((CharSequence)builder.toString());
        this.breadcrumb.setVisibility(0);
    }

    public void updateDialog(int HeaderStringResId, List<? extends AddressEntity> addressEntityList) {
        this.header.setText(HeaderStringResId);
        this.setListAdapter(new AddressListAdapter<AddressEntity>(this.getContext(), addressEntityList));
    }

    private void setListAdapter(AddressListAdapter addressListAdapter) {
        this.addressListAdapter = addressListAdapter;
        this.list.setAdapter((ListAdapter)addressListAdapter);
    }

    private void notifyAddressChange(String code) {
        Address address = this.addressRepository.findByCode(code);
        this.onAddressChangedListener.onAddressChanged(address);
    }

    @Override
    public void show(Address area) {
        this.addressStack = new ArrayStack();
        if (area != null) {
            this.addressStack.push((AddressEntity)area.getProvince());
            this.addressStack.push((AddressEntity)area.getDistrict());
        }
        this.show();
    }

    @Override
    public void show(String addressCode) {
        this.show(this.addressRepository.findByCode(addressCode));
    }

    @Override
    public void setOnAddressChangedListener(AddressView.OnAddressChangedListener onAddressChangedListener) {
        this.onAddressChangedListener = onAddressChangedListener;
    }
}

