/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.thai.widget.address.repository;

import android.content.Context;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.thai.address.AddressRepository;
import th.or.nectec.thai.address.InvalidAddressCodeFormatException;
import th.or.nectec.thai.address.SubDistrict;
import th.or.nectec.thai.widget.address.repository.JsonParser;

public class SubDistrictRepository
implements AddressRepository<SubDistrict> {
    private static SubDistrictRepository instance;
    private List<SubDistrict> allSubDistrict = new ArrayList<SubDistrict>();

    private SubDistrictRepository(Context context) {
        this.allSubDistrict = JsonParser.parse(context, "subdistrict.json", SubDistrict.class);
    }

    public static SubDistrictRepository getInstance(Context context) {
        if (instance == null) {
            instance = new SubDistrictRepository(context);
        }
        return instance;
    }

    public List<SubDistrict> find() {
        return this.allSubDistrict;
    }

    public List<SubDistrict> findByParentCode(String districtCode) {
        if (districtCode.length() != 4) {
            throw new InvalidAddressCodeFormatException.InvalidDistrictCodeException(districtCode);
        }
        ArrayList<SubDistrict> querySubDistrict = new ArrayList<SubDistrict>();
        for (SubDistrict eachSubDistrict : this.allSubDistrict) {
            String queryAddressCode = eachSubDistrict.getDistrictCode();
            if (!queryAddressCode.equals(districtCode)) continue;
            querySubDistrict.add(eachSubDistrict);
        }
        return querySubDistrict.isEmpty() ? null : querySubDistrict;
    }

    public SubDistrict findByCode(String subDistrictCode) {
        if (subDistrictCode.length() != 6) {
            throw new InvalidAddressCodeFormatException.InvalidSubDistrictCodeException(subDistrictCode);
        }
        for (SubDistrict eachSubDistrict : this.allSubDistrict) {
            String queryAddressCode = eachSubDistrict.getCode();
            if (!queryAddressCode.equals(subDistrictCode)) continue;
            return eachSubDistrict;
        }
        return null;
    }
}

