/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Parcelable;
import android.support.v7.widget.AppCompatButton;
import android.support.v7.widget.TintManager;
import android.support.v7.widget.TintTypedArray;
import android.util.AttributeSet;
import android.widget.TextView;
import th.or.nectec.android.widget.thai.OnAddressChangedListener;
import th.or.nectec.android.widget.thai.R;
import th.or.nectec.android.widget.thai.address.AddressPickerHandler;
import th.or.nectec.android.widget.thai.address.AddressSavedState;
import th.or.nectec.android.widget.thai.address.AddressView;
import th.or.nectec.entity.thai.Address;

public class AppCompatAddressPicker
extends AppCompatButton
implements AddressView {
    public static final int[] TINT_ATTRS = new int[]{16842964};
    private AddressPickerHandler addressPickerHandler;

    public AppCompatAddressPicker(Context context) {
        this(context, null);
    }

    public AppCompatAddressPicker(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.spinnerStyle);
    }

    public AppCompatAddressPicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initTintManager(attrs, defStyleAttr);
        this.addressPickerHandler = new AddressPickerHandler((TextView)this, context);
    }

    private void initTintManager(AttributeSet attrs, int defStyleAttr) {
        if (TintManager.SHOULD_BE_USED) {
            ColorStateList tint;
            TintTypedArray a = TintTypedArray.obtainStyledAttributes((Context)this.getContext(), (AttributeSet)attrs, (int[])TINT_ATTRS, (int)defStyleAttr, (int)0);
            if (a.hasValue(0) && (tint = a.getTintManager().getTintList(a.getResourceId(0, -1))) != null) {
                this.setSupportBackgroundTintList(tint);
            }
            a.recycle();
        }
    }

    public boolean performClick() {
        return this.addressPickerHandler.performClick();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable parcelable = super.onSaveInstanceState();
        AddressSavedState savedState = new AddressSavedState(parcelable);
        Address address = this.addressPickerHandler.getAddress();
        savedState.addressCode = address == null ? null : address.getSubdistrictCode();
        return savedState;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof AddressSavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        AddressSavedState ss = (AddressSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setAddressCode(ss.addressCode);
    }

    @Override
    public void setAddressCode(String addressCode) {
        this.addressPickerHandler.setAddressCode(addressCode);
    }

    @Override
    public void setAddress(String subdistrict, String district, String province) {
        this.addressPickerHandler.setAddress(subdistrict, district, province);
    }

    @Override
    public void setOnAddressChangedListener(OnAddressChangedListener onAddressChangedListener) {
        this.addressPickerHandler.setOnAddressChangedListener(onAddressChangedListener);
    }

    @Override
    public Address getAddress() {
        return this.addressPickerHandler.getAddress();
    }
}

