/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.domain.thai.address.SubdistrictRepository;
import th.or.nectec.entity.thai.InvalidCodeFormatException;
import th.or.nectec.entity.thai.Subdistrict;

class InMemoryJsonSubdistrictRepository
implements SubdistrictRepository {
    static InMemoryJsonSubdistrictRepository instance;
    ArrayList<Subdistrict> allSubdistrict = new ArrayList();

    public InMemoryJsonSubdistrictRepository(Context context) {
        try {
            InputStream inputStream = context.getAssets().open("subdistrict.json");
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
            Gson gson = new Gson();
            reader.beginArray();
            while (reader.hasNext()) {
                Subdistrict subdistrict = (Subdistrict)gson.fromJson(reader, Subdistrict.class);
                this.allSubdistrict.add(subdistrict);
            }
            reader.endArray();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static InMemoryJsonSubdistrictRepository getInstance(Context context) {
        if (instance == null) {
            instance = new InMemoryJsonSubdistrictRepository(context);
        }
        return instance;
    }

    public List<Subdistrict> findByDistrictCode(String districtCode) {
        if (districtCode.length() != 4) {
            throw new InvalidCodeFormatException();
        }
        ArrayList<Subdistrict> querySubdistrict = new ArrayList<Subdistrict>();
        for (Subdistrict eachSubdistrict : this.allSubdistrict) {
            String queryAddressCode = eachSubdistrict.getDistrictCode();
            if (!queryAddressCode.equals(districtCode)) continue;
            querySubdistrict.add(eachSubdistrict);
        }
        return querySubdistrict.isEmpty() ? null : querySubdistrict;
    }

    public Subdistrict findBySubdistrictCode(String addressCode) {
        for (Subdistrict eachSubdistrict : this.allSubdistrict) {
            String queryAddressCode = eachSubdistrict.getCode();
            if (!queryAddressCode.equals(addressCode)) continue;
            return eachSubdistrict;
        }
        return null;
    }

    public ArrayList<Subdistrict> findByName(String subdistrict) {
        ArrayList<Subdistrict> subdistricts = new ArrayList<Subdistrict>();
        for (Subdistrict eachSubdistrict : this.allSubdistrict) {
            if (!eachSubdistrict.getName().equals(subdistrict)) continue;
            subdistricts.add(eachSubdistrict);
        }
        return subdistricts.isEmpty() ? null : subdistricts;
    }
}

