/*
 * Decompiled with CFR 0.152.
 */
package th.or.nectec.android.widget.thai.address;

import android.content.Context;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import th.or.nectec.domain.thai.address.DistrictRepository;
import th.or.nectec.entity.thai.District;
import th.or.nectec.entity.thai.InvalidCodeFormatException;

class InMemoryJsonDistrictRepository
implements DistrictRepository {
    public static InMemoryJsonDistrictRepository instance;
    ArrayList<District> allDistrict = new ArrayList();

    public InMemoryJsonDistrictRepository(Context context) {
        try {
            InputStream inputStream = context.getAssets().open("district.json");
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream, "UTF-8"));
            Gson gson = new Gson();
            reader.beginArray();
            while (reader.hasNext()) {
                District message = (District)gson.fromJson(reader, District.class);
                this.allDistrict.add(message);
            }
            reader.endArray();
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static InMemoryJsonDistrictRepository getInstance(Context context) {
        if (instance == null) {
            instance = new InMemoryJsonDistrictRepository(context);
        }
        return instance;
    }

    public List<District> findByProvinceCode(String provinceCode) {
        if (provinceCode.length() != 2) {
            throw new InvalidCodeFormatException();
        }
        ArrayList<District> queryDistrict = new ArrayList<District>();
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(provinceCode)) continue;
            queryDistrict.add(eachDistrict);
        }
        return queryDistrict.isEmpty() ? null : queryDistrict;
    }

    public District findByDistrictCode(String districtCode) {
        if (districtCode.length() != 4) {
            throw new InvalidCodeFormatException();
        }
        for (District eachDistrict : this.allDistrict) {
            String queryDistrictCode = eachDistrict.getCode();
            if (!queryDistrictCode.startsWith(districtCode)) continue;
            return eachDistrict;
        }
        return null;
    }
}

